//------------------------------------------------------------------
//  Pair.js
//  Copyright 2015 Applied Invention, LLC.
//------------------------------------------------------------------

//------------------------------------------------------------------
import * as axeString from "../util/string";
//------------------------------------------------------------------

/** A pair of 2 values
 */
export class Pair<T, U>
{
  //----------------------------------------------------------------
  // Properties
  //----------------------------------------------------------------

  /** The first value in the pair.
   */
  first: T;

  /** The second value in the pair.
   */
  second: U;

  //----------------------------------------------------------------
  // Initialization
  //----------------------------------------------------------------

  /** Initializes a new Pair object.
   */
  constructor(first: T, second: U)
  {
    this.first = first;
    this.second = second;
  }

  //------------------------------------------------------------------
  // Methods
  //------------------------------------------------------------------

  /** Returns a string representation of this object.
   */
  toString() : string
  {
    let propertyNames = [ "first", "second" ];
    return axeString.formatObject("Pair", this, propertyNames);
  }

} // END class Pair
