//------------------------------------------------------------------
//  ImageDialogCtrl.js
//  Copyright 2013 AppliedMinds, Inc.
//------------------------------------------------------------------

"use strict";

/** Controller for the ImageDialog directive.
 */
function ImageDialogCtrl(ngScope, ngElement, ngTimeout)
{
  //----------------------------------------------------------------
  // Properties
  //----------------------------------------------------------------

  /** The top title to show.
   */
  ngScope.title1;

  /** The sub-title to show.
   */
  ngScope.title2;

  /** The URL of the image to display.
   */
  ngScope.imageUrl;

  /** The width of the image to display.
   */
  ngScope.imageWidth;

  /** The height of the image to display.
   */
  ngScope.imageHeight;

  //----------------------------------------------------------------
  // Initialization
  //----------------------------------------------------------------

  /** Initializes a new ImageDialogCtrl object.
   */
  ngScope.initImageDialogCtrl = function()
  {
  }

  //----------------------------------------------------------------
  // Methods
  //----------------------------------------------------------------

  /** Called when this dialog has been opened.
   */
  ngScope.open = function(title1,
			  title2,
			  imageUrl,
			  imageWidth,
			  imageHeight)
  {
    ngScope.title1 = title1;
    ngScope.title2 = title2;
    ngScope.imageUrl = imageUrl;
    ngScope.imageWidth = imageWidth;
    ngScope.imageHeight = imageHeight;

    var imgFrame = ngElement.children('div');
    var imgList = imgFrame.children('img');
    var img = imgList[0];

    // Setting the img src explicitly solves event order problems
    // where the image was loaded after the dialog was open,
    // so size and centering were wrong.
    img.src = imageUrl;

    img.style.width = imageWidth + 'px';
    img.style.height = imageHeight + 'px';

    // If the image has already been loaded, show the dialog now.
    // Otherwise wait for the 'load' event to show the dialog.
    // This avoids flashing the wrong image as the dialog opens.
    if (img.complete)
    {
      ngScope.openDialog();
    }
    else
    {
      imgList.one('load', axe.func.bind(ngScope, 'openDialog'));
    }

  }

  //----------------------------------------------------------------
  // Call the init method to initialize the new object.
  // Do not edit this line.
  ngScope.initImageDialogCtrl();
  //----------------------------------------------------------------

} // END class ImageDialogCtrl

ImageDialogCtrl.$inject = ['$scope', '$element', '$timeout'];
