#-------------------------------------------------------------------
#  __init__.py
#
#  Package __init__ file.
#
#  Copyright 2018 Applied Invention, LLC
#-------------------------------------------------------------------

'''The sqlalchemy package.
'''

#-------------------------------------------------------------------
# Import statements go here.
#
#from .schema import Column
from typing import Any
from typing import Generic
from typing import overload
from typing import Type
from typing import TypeVar
#
# Import statements go above this line.
#-------------------------------------------------------------------

# Default value that tells mypy that anything not listed in this file
# should be treated as an 'Any'.
def __getattr__(name) -> Any:  ...

#-------------------------------------------------------------------
# The Column stub.
#
# This stub tries to make mypy understand the magic that SQLAlchemy does.
#
# When you make a class member Column object like
#
#   class TriCycle(SqlBase):
#
#     numWheels = Column(Integer)
#
# the SqlBase object changes the class member type to InstrumentedAttribute,
# so that you can do tricky SQL query stuff like
#
#   session.query(TriCycle).filter(TriCycle.numWheels == 4)
#
# and also sets an instance member with the same name that has
# a python type corresponding to the Column type, so you can do:
#
#   myCycle = session.query(TriCycle)
#
#   print('my cycle has %s wheels' % myCycle.numWheels)
#   myCycle.numWheels = 6
#
#
# A problem with this stub:
#
# When you have a class that actually uses a Column object for something
# (like DbDict which contains dynamically-created Column objects for the
# key and values types), mypy will get confused and give you lots of
# of errors because it's using the rules for Column objects as static members
# of SqlBase subclasses.
#
# To work around this, you'll have to use 'Any' for those Column types.


# The annotated class (such as 'Account').
Clazz = TypeVar('Clazz')

# The python type of the column (such as 'int').
PythonType = TypeVar('PythonType')

class Column(Generic[PythonType]):

  def __init__(self, pythonType: Type[PythonType], *args, **kwargs) -> None: ...

  # This actually returns an InstrumentedAttribute.
  # For now, just call it 'Any' to disable all checking.
  # Eventually, it would be nice to have a stub for InstrumentedAttribute.
  @overload
  def __get__(self, obj: None, theType: Type[Clazz]) -> Any: ...

  @overload
  def __get__(self, obj: Clazz, theType: Type[Clazz]) -> PythonType: ...

  def __set__(self, obj: Clazz, value: PythonType) -> None: ...
