#-------------------------------------------------------------------
#  WktTestGeometry.py
#
#  The WktTestGeometry class.
#
#  Copyright 2016 Applied Invention, LLC
#-------------------------------------------------------------------

'''The module containing the WktTestGeometry class.
'''

#-------------------------------------------------------------------
# Import statements go here.
#
from ai.axe.build.unittest import AxeSimpleTestCase
from ai.axe.wkt import GeoShape
from ai.axe.wkt import WkbReader
from ai.axe.wkt import WkbWriter
from ai.axe.wkt import WktReader
from ai.axe.wkt import WktWriter
#
# Import statements go above this line.
#-------------------------------------------------------------------


#===================================================================
class WktTestGeometry:
  '''An object that holds information about a single test geo spacial object.
  '''

  #-----------------------------------------------------------------
  def __init__(self,
               name: str,
               obj: GeoShape,
               wkt: str,
               wkbBig: str,
               wkbLittle: str) -> None:
    '''Creates a new WktTestGeometry.
    '''

    # The name of this test to be used in output to the user.
    self.name = name

    # The geospacial object being converted from/to wkt/b.
    self.obj = obj

    # The WKT form of the object.
    self.wkt = wkt

    # The big-endian WKB form of the object.
    self.wkbBig = wkbBig

    # The little-endian WKB form of the object.
    self.wkbLittle = wkbLittle

  #-----------------------------------------------------------------
  def runReadBinaryTest(self, unitTest: AxeSimpleTestCase) -> None:
    '''Runs the test for this data.
    '''

    reader = WkbReader()

    expected = self.obj
    actual = reader.read(self.wkbBig)
    unitTest.assertEqual(expected, actual, self.name + " big")

    expected = self.obj
    actual = reader.read(self.wkbLittle)
    unitTest.assertEqual(expected, actual, self.name + " little")

  #-----------------------------------------------------------------
  def runWriteBinaryTest(self, unitTest: AxeSimpleTestCase) -> None:
    '''Runs the test for this data.
    '''

    writer = WkbWriter(byteOrder='big')

    expected = self.wkbBig
    actual = writer.write(self.obj)
    unitTest.assertEqual(expected, actual, self.name + " big")

    writer = WkbWriter(byteOrder='little')

    expected = self.wkbLittle
    actual = writer.write(self.obj)
    unitTest.assertEqual(expected, actual, self.name + " little")

  #-----------------------------------------------------------------
  def runReadTextTest(self, unitTest: AxeSimpleTestCase) -> None:
    '''Runs the test for this data.
    '''

    reader = WktReader()

    expected = self.obj
    actual = reader.read(self.wkt)
    unitTest.assertEqual(expected, actual, self.name)

  #-----------------------------------------------------------------
  def runWriteTextTest(self, unitTest: AxeSimpleTestCase) -> None:
    '''Runs the test for this data.
    '''

    writer = WktWriter()

    expected = self.wkt
    actual = writer.write(self.obj)
    unitTest.assertEqual(expected, actual, self.name)
