#-------------------------------------------------------------------
#  WktTestData.py
#
#  The WktTestData module.
#
#  Copyright 2016 Applied Invention, LLC
#-------------------------------------------------------------------

'''Geo spacial objects for testing.
'''

#-------------------------------------------------------------------
# Import statements go here.
#
from ai.axe.wkt import LineString
from ai.axe.wkt import Point
from ai.axe.wkt import Point3d
from ai.axe.wkt import Polygon
from ai.axe.wkt import PolygonRing
from ai.axe.wkt import MultiPolygon
from .WktTestGeometry import WktTestGeometry
from typing import List
#
# Import statements go above this line.
#-------------------------------------------------------------------

# pylint: disable=C0301

#-------------------------------------------------------------------
ring1 = PolygonRing([Point(100.2, 100.2), Point(100.2, 110.2),
                     Point(110.2, 110.2), Point(110.2, 100.2),
                     Point(100.2, 100.2)])

# A ring that's interior to ring 1.
ring1Interior = PolygonRing([Point(101, 101), Point(101, 109),
                             Point(109, 109), Point(109, 101),
                             Point(101, 101)])

# Two interior rings that don't overlap each other.
ring1InteriorA = PolygonRing([Point(101, 101), Point(101, 104),
                              Point(109, 104), Point(109, 101),
                              Point(101, 101)])
ring1InteriorB = PolygonRing([Point(101, 106), Point(101, 109),
                              Point(109, 109), Point(109, 106),
                              Point(101, 106)])

ring2 = PolygonRing([Point(200.2, 100.2), Point(200.2, 110.2),
                     Point(210.2, 110.2), Point(210.2, 100.2),
                     Point(200.2, 100.2)])

#-------------------------------------------------------------------
def getTestObject(name: str) -> WktTestGeometry:
  '''Returns the test object with the specified name.
  '''

  for testObj in testObjects:
    if testObj.name == name:
      return testObj

  raise ValueError('Invalid name: ' + str(name))
#-------------------------------------------------------------------
testObjects: List[WktTestGeometry] = [

WktTestGeometry(
  'point',
  Point(1234.5, 5678.9),
  'POINT(1234.5 5678.9)',
  '000000000140934a000000000040b62ee666666666',
  '010100000000000000004a934066666666e62eb640'),

WktTestGeometry(
  'point_3d',
  Point3d(1234.5, 5678.9, 1011.1213),
  'POINT Z(1234.5 5678.9 1011.1213)',
  '00000003e940934a000000000040b62ee666666666408f98f86c22680a',
  '01e903000000000000004a934066666666e62eb6400a68226cf8988f40'),

WktTestGeometry(
  'linestring',
  LineString([Point(1.2, 3.4), Point(5.6, 7.8), Point(9, 10.11)]),
  'LINESTRING(1.2 3.4,5.6 7.8,9 10.11)',
  '0000000002000000033ff3333333333333400b3333333333334016666666666666401f333333333333402200000000000040243851eb851eb8',
  '010200000003000000333333333333f33f3333333333330b4066666666666616403333333333331f400000000000002240b81e85eb51382440'),

WktTestGeometry(
  'polygon_1ring',
  Polygon([ring1]),
  'POLYGON((100.2 100.2,100.2 110.2,110.2 110.2,110.2 100.2,100.2 100.2))',
  '0000000003000000010000000540590ccccccccccd40590ccccccccccd40590ccccccccccd405b8ccccccccccd405b8ccccccccccd405b8ccccccccccd405b8ccccccccccd40590ccccccccccd40590ccccccccccd40590ccccccccccd',
  '01030000000100000005000000cdcccccccc0c5940cdcccccccc0c5940cdcccccccc0c5940cdcccccccc8c5b40cdcccccccc8c5b40cdcccccccc8c5b40cdcccccccc8c5b40cdcccccccc0c5940cdcccccccc0c5940cdcccccccc0c5940'),

WktTestGeometry(
  'polygon_2ring',
  Polygon([ring1, ring1Interior]),
  'POLYGON((100.2 100.2,100.2 110.2,110.2 110.2,110.2 100.2,100.2 100.2),(101 101,101 109,109 109,109 101,101 101))',
  '0000000003000000020000000540590ccccccccccd40590ccccccccccd40590ccccccccccd405b8ccccccccccd405b8ccccccccccd405b8ccccccccccd405b8ccccccccccd40590ccccccccccd40590ccccccccccd40590ccccccccccd00000005405940000000000040594000000000004059400000000000405b400000000000405b400000000000405b400000000000405b400000000000405940000000000040594000000000004059400000000000',
  '01030000000200000005000000cdcccccccc0c5940cdcccccccc0c5940cdcccccccc0c5940cdcccccccc8c5b40cdcccccccc8c5b40cdcccccccc8c5b40cdcccccccc8c5b40cdcccccccc0c5940cdcccccccc0c5940cdcccccccc0c5940050000000000000000405940000000000040594000000000004059400000000000405b400000000000405b400000000000405b400000000000405b40000000000040594000000000004059400000000000405940'),

WktTestGeometry(
  'polygon_3ring',
  Polygon([ring1, ring1InteriorA, ring1InteriorB]),
  'POLYGON((100.2 100.2,100.2 110.2,110.2 110.2,110.2 100.2,100.2 100.2),(101 101,101 104,109 104,109 101,101 101),(101 106,101 109,109 109,109 106,101 106))',
  '0000000003000000030000000540590ccccccccccd40590ccccccccccd40590ccccccccccd405b8ccccccccccd405b8ccccccccccd405b8ccccccccccd405b8ccccccccccd40590ccccccccccd40590ccccccccccd40590ccccccccccd00000005405940000000000040594000000000004059400000000000405a000000000000405b400000000000405a000000000000405b400000000000405940000000000040594000000000004059400000000000000000054059400000000000405a8000000000004059400000000000405b400000000000405b400000000000405b400000000000405b400000000000405a8000000000004059400000000000405a800000000000',
  '01030000000300000005000000cdcccccccc0c5940cdcccccccc0c5940cdcccccccc0c5940cdcccccccc8c5b40cdcccccccc8c5b40cdcccccccc8c5b40cdcccccccc8c5b40cdcccccccc0c5940cdcccccccc0c5940cdcccccccc0c5940050000000000000000405940000000000040594000000000004059400000000000005a400000000000405b400000000000005a400000000000405b400000000000405940000000000040594000000000004059400500000000000000004059400000000000805a4000000000004059400000000000405b400000000000405b400000000000405b400000000000405b400000000000805a4000000000004059400000000000805a40'),

WktTestGeometry(
  'multipolygon_1',
  MultiPolygon([Polygon([ring1])]),
  'MULTIPOLYGON(((100.2 100.2,100.2 110.2,110.2 110.2,110.2 100.2,100.2 100.2)))',
  '0000000006000000010000000003000000010000000540590ccccccccccd40590ccccccccccd40590ccccccccccd405b8ccccccccccd405b8ccccccccccd405b8ccccccccccd405b8ccccccccccd40590ccccccccccd40590ccccccccccd40590ccccccccccd',
  '01060000000100000001030000000100000005000000cdcccccccc0c5940cdcccccccc0c5940cdcccccccc0c5940cdcccccccc8c5b40cdcccccccc8c5b40cdcccccccc8c5b40cdcccccccc8c5b40cdcccccccc0c5940cdcccccccc0c5940cdcccccccc0c5940'),

WktTestGeometry(
  'multipolygon_2',
  MultiPolygon([Polygon([ring1]), Polygon([ring2])]),
  'MULTIPOLYGON(((100.2 100.2,100.2 110.2,110.2 110.2,110.2 100.2,100.2 100.2)),((200.2 100.2,200.2 110.2,210.2 110.2,210.2 100.2,200.2 100.2)))',
  '0000000006000000020000000003000000010000000540590ccccccccccd40590ccccccccccd40590ccccccccccd405b8ccccccccccd405b8ccccccccccd405b8ccccccccccd405b8ccccccccccd40590ccccccccccd40590ccccccccccd40590ccccccccccd00000000030000000100000005406906666666666640590ccccccccccd4069066666666666405b8ccccccccccd406a466666666666405b8ccccccccccd406a46666666666640590ccccccccccd406906666666666640590ccccccccccd',
  '01060000000200000001030000000100000005000000cdcccccccc0c5940cdcccccccc0c5940cdcccccccc0c5940cdcccccccc8c5b40cdcccccccc8c5b40cdcccccccc8c5b40cdcccccccc8c5b40cdcccccccc0c5940cdcccccccc0c5940cdcccccccc0c5940010300000001000000050000006666666666066940cdcccccccc0c59406666666666066940cdcccccccc8c5b406666666666466a40cdcccccccc8c5b406666666666466a40cdcccccccc0c59406666666666066940cdcccccccc0c5940'),

]
