#-------------------------------------------------------------------
#  wkbRasterTestData.py
#
#  The wkbRasterTestData module.
#
#  Copyright 2016 Applied Invention, LLC
#-------------------------------------------------------------------

'''Data for testing WKB raster functions.
'''

#-------------------------------------------------------------------
# Import statements go here.
#
from ai.axe.wkt import Raster
from ai.axe.wkt import RasterBand
from .WktTestRaster import WktTestRaster
from typing import List
#
# Import statements go above this line.
#-------------------------------------------------------------------

# pylint: disable=C0301

#-------------------------------------------------------------------
def createTestRasters() -> List[WktTestRaster]:

  testRasters = [

WktTestRaster('bb1',
 createRaster(createBandUi1()),
'0000000001400800000000000040100000000000003ff0000000000000400000000000000040140000000000004018000000000000000010e6000200030000010001000100',
'010000010000000000000008400000000000001040000000000000F03F000000000000004000000000000014400000000000001840E6100000020003000000010001000100'),

WktTestRaster('bui2',
 createRaster(createBandUi2()),
'0000000001400800000000000040100000000000003ff0000000000000400000000000000040140000000000004018000000000000000010e6000200030100010203000102',
'010000010000000000000008400000000000001040000000000000F03F000000000000004000000000000014400000000000001840E6100000020003000100010203000102'),

WktTestRaster('bui4',
 createRaster(createBand(2, False)),
'0000000001400800000000000040100000000000003ff0000000000000400000000000000040140000000000004018000000000000000010e6000200034207010203040506',
'010000010000000000000008400000000000001040000000000000F03F000000000000004000000000000014400000000000001840E6100000020003004207010203040506'),

WktTestRaster('si8',
 createRaster(createBand(3, True)),
'0000000001400800000000000040100000000000003ff0000000000000400000000000000040140000000000004018000000000000000010e600020003430701fe03fc05fa',
'010000010000000000000008400000000000001040000000000000F03F000000000000004000000000000014400000000000001840E610000002000300430701FE03FC05FA'),

WktTestRaster('ui8',
 createRaster(createBand(4, False)),
'0000000001400800000000000040100000000000003ff0000000000000400000000000000040140000000000004018000000000000000010e6000200034407010203040506',
'010000010000000000000008400000000000001040000000000000F03F000000000000004000000000000014400000000000001840E6100000020003004407010203040506'),

WktTestRaster('si16',
 createRaster(createBand(5, True)),
'0000000001400800000000000040100000000000003ff0000000000000400000000000000040140000000000004018000000000000000010e6000200034500070001fffe0003fffc0005fffa',
'010000010000000000000008400000000000001040000000000000F03F000000000000004000000000000014400000000000001840E6100000020003004507000100FEFF0300FCFF0500FAFF'),

WktTestRaster('ui16',
 createRaster(createBand(6, False)),
'0000000001400800000000000040100000000000003ff0000000000000400000000000000040140000000000004018000000000000000010e600020003460007000100020003000400050006',
'010000010000000000000008400000000000001040000000000000F03F000000000000004000000000000014400000000000001840E610000002000300460700010002000300040005000600'),

WktTestRaster('si32',
 createRaster(createBand(7, True)),
'0000000001400800000000000040100000000000003ff0000000000000400000000000000040140000000000004018000000000000000010e600020003470000000700000001fffffffe00000003fffffffc00000005fffffffa',
'010000010000000000000008400000000000001040000000000000F03F000000000000004000000000000014400000000000001840E610000002000300470700000001000000FEFFFFFF03000000FCFFFFFF05000000FAFFFFFF'),

WktTestRaster('ui32',
 createRaster(createBand(8, False)),
'0000000001400800000000000040100000000000003ff0000000000000400000000000000040140000000000004018000000000000000010e6000200034800000007000000010000000200000003000000040000000500000006',
'010000010000000000000008400000000000001040000000000000F03F000000000000004000000000000014400000000000001840E6100000020003004807000000010000000200000003000000040000000500000006000000'),

WktTestRaster('f32',
 createRaster(createBand(10, True)),
'0000000001400800000000000040100000000000003ff0000000000000400000000000000040140000000000004018000000000000000010e6000200034a40e000003f800000c000000040400000c080000040a00000c0c00000',
'010000010000000000000008400000000000001040000000000000F03F000000000000004000000000000014400000000000001840E6100000020003004A0000E0400000803F000000C000004040000080C00000A0400000C0C0'),

WktTestRaster('f64',
 createRaster(createBand(11, True)),
'0000000001400800000000000040100000000000003ff0000000000000400000000000000040140000000000004018000000000000000010e6000200034b401c0000000000003ff0000000000000c0000000000000004008000000000000c0100000000000004014000000000000c018000000000000',
'010000010000000000000008400000000000001040000000000000F03F000000000000004000000000000014400000000000001840E6100000020003004B0000000000001C40000000000000F03F00000000000000C0000000000000084000000000000010C0000000000000144000000000000018C0'),

WktTestRaster('bands2',
createRasterBands2(11),
'0000000002400800000000000040100000000000003ff0000000000000400000000000000040140000000000004018000000000000000010e6000200034b401c0000000000003ff0000000000000c0000000000000004008000000000000c0100000000000004014000000000000c0180000000000004b401c000000000000401c00000000000040200000000000004022000000000000402400000000000040260000000000004028000000000000',
'010000020000000000000008400000000000001040000000000000F03F000000000000004000000000000014400000000000001840E6100000020003004B0000000000001C40000000000000F03F00000000000000C0000000000000084000000000000010C0000000000000144000000000000018C04B0000000000001C400000000000001C4000000000000020400000000000002240000000000000244000000000000026400000000000002840'),

]

  return testRasters

#-------------------------------------------------------------------
def createRasterBands2(pixelType: int) -> Raster:

  values1 = [[1, -2], [3, -4], [5, -6]]
  values2 = [[None, 8], [9, 10], [11, 12]]

  noData = 7

  bands = [
    RasterBand(pixelType, noData, False, values1),
    RasterBand(pixelType, noData, False, values2),
  ]

  return Raster(2, 3, 1, 2, 3, 4, 5, 6, 4326, bands)

#-------------------------------------------------------------------
def createRaster(band: RasterBand) -> Raster:

  return Raster(2, 3, 1, 2, 3, 4, 5, 6, 4326, [band])

#-------------------------------------------------------------------
def createBandUi1() -> RasterBand:

  band = createBand(0, False)
  band.values = [[1, 0], [1, 0], [1, 0]]
  band.noData = None

  return band

#-------------------------------------------------------------------
def createBandUi2() -> RasterBand:

  band = createBand(1, False)
  band.values = [[1, 2], [3, 0], [1, 2]]
  band.noData = None

  return band

#-------------------------------------------------------------------
def createBand(pixelType: int, isSigned: bool) -> RasterBand:

  values = [[1, 2], [3, 4], [5, 6]]
  if isSigned:
    values = [[1, -2], [3, -4], [5, -6]]

  return RasterBand(pixelType, 7, False, values)
