#-------------------------------------------------------------------
#  TestWkbRasterReader.py
#
#  The TestWkbRasterReader module.
#
#  Copyright 2016 Applied Invention, LLC
#-------------------------------------------------------------------

'''Unit test for the WkbRasterReader class.
'''

#-------------------------------------------------------------------
# Import statements go here.
#
from ai.axe.wkt import WkbRasterReader
from ai.axe.build.unittest import AxeSimpleTestCase
from . import WktRasterTestData
#
# Import statements go above this line.
#-------------------------------------------------------------------

#===================================================================
class TestWkbRasterReader(AxeSimpleTestCase):
  '''Unit test for the WkbRasterReader class.
'''

  #-----------------------------------------------------------------
  def setUp(self) -> None:

    # Put initialization code here.  It will be run before each test.
    pass

  #-----------------------------------------------------------------
  def tearDown(self) -> None:

    # Put finalization code here.  It will be run after each test.
    pass

  #-----------------------------------------------------------------
  def testReading(self) -> None:
    '''Test reading a raster.
    '''

    for testObj in WktRasterTestData.createTestRasters():
      testObj.runReadTest(self)

  #-----------------------------------------------------------------
  def testTooShort(self) -> None:
    '''Test reading an invalid too-short string.
    '''

    reader = WkbRasterReader()

    try:
      reader.read("")
      self.fail("No exception for too-short input.")
    except ValueError:
      pass
