#-------------------------------------------------------------------
#  TestRaster.py
#
#  The TestRaster module.
#
#  Copyright 2016 Applied Invention, LLC
#-------------------------------------------------------------------

'''Unit test for the Raster class.
'''

#-------------------------------------------------------------------
# Import statements go here.
#
from ai.axe.wkt import Raster
from ai.axe.wkt import RasterBand
from ai.axe.build.unittest import AxeSimpleTestCase
#
# Import statements go above this line.
#-------------------------------------------------------------------

#===================================================================
class TestRaster(AxeSimpleTestCase):
  '''Unit test for the Raster class.
'''

  #-----------------------------------------------------------------
  def setUp(self) -> None:

    # Put initialization code here.  It will be run before each test.
    pass

  #-----------------------------------------------------------------
  def tearDown(self) -> None:

    # Put finalization code here.  It will be run after each test.
    pass

  #-----------------------------------------------------------------
  def testCtor(self) -> None:
    '''Test creating a raster.
    '''

    bands = [
      RasterBand(8, 7, False, [[1], [2]]),
      RasterBand(8, 7, False, [[1], [2]]),
      ]

    raster = Raster(1, 2, 3, 4, 5, 6, 7, 8, 4326, bands)

    self.assertEqual(1, raster.width, "width")
    self.assertEqual(2, raster.height, "height")
    self.assertEqual(3, raster.upperLeftX, "upperLeftX")
    self.assertEqual(4, raster.upperLeftY, "upperLeftY")
    self.assertEqual(5, raster.scaleX, "scaleX")
    self.assertEqual(6, raster.scaleY, "scaleY")
    self.assertEqual(7, raster.skewX, "skewX")
    self.assertEqual(8, raster.skewY, "skewY")
    self.assertEqual(4326, raster.srid, "srid")
    self.assertEqual(2, len(raster.bands), "# bands")

    raster = raster.createCopy()

    self.assertEqual(1, raster.width, "width")
    self.assertEqual(2, raster.height, "height")
    self.assertEqual(3, raster.upperLeftX, "upperLeftX")
    self.assertEqual(4, raster.upperLeftY, "upperLeftY")
    self.assertEqual(5, raster.scaleX, "scaleX")
    self.assertEqual(6, raster.scaleY, "scaleY")
    self.assertEqual(7, raster.skewX, "skewX")
    self.assertEqual(8, raster.skewY, "skewY")
    self.assertEqual(4326, raster.srid, "srid")
    self.assertEqual(0, len(raster.bands), "# bands")

    # Check that str() doesn't throw an exception.
    str(raster)

  #-----------------------------------------------------------------
  def testStaticCreate(self) -> None:
    '''Test creating a raster.
    '''

    values = [[1], [2]]

    raster = Raster.create(3, 4, 5, 6, values)

    self.assertEqual(1, raster.width, "width")
    self.assertEqual(2, raster.height, "height")
    self.assertEqual(3, raster.upperLeftX, "upperLeftX")
    self.assertEqual(4, raster.upperLeftY, "upperLeftY")
    self.assertEqual(5, raster.scaleX, "scaleX")
    self.assertEqual(6, raster.scaleY, "scaleY")
    self.assertEqual(0, raster.skewX, "skewX")
    self.assertEqual(0, raster.skewY, "skewY")
    self.assertEqual(4326, raster.srid, "srid")
    self.assertEqual(1, len(raster.bands), "# bands")

  #-----------------------------------------------------------------
  def testValidate(self) -> None:
    '''Test validating a raster.
    '''

    bands = [
      RasterBand(8, 7, False, [[1], [2]]),
      RasterBand(8, 7, False, [[1], [2]]),
      ]

    raster = Raster(1, 2, 3, 4, 5, 6, 7, 8, 4326, bands)

    # Should pass with no exceptions.
    raster.validate()

    # Second raster height is bad.

    raster.bands[1] = RasterBand(8, 7, False, [[1], [2], [3]])

    try:
      raster.validate()
      self.fail("No exception for bad sized raster.")
    except ValueError:
      pass

    # First raster width is bad.

    raster.bands[1] = RasterBand(8, 7, False, [[1], [2, 3]])

    try:
      raster.validate()
      self.fail("No exception for bad sized raster.")
    except ValueError:
      pass
