#-------------------------------------------------------------------
#  TestPolygonRing.py
#
#  The TestPolygonRing module.
#
#  Copyright 2016 Applied Invention, LLC
#-------------------------------------------------------------------

'''Unit test for the PolygonRing class.
'''

#-------------------------------------------------------------------
# Import statements go here.
#
from ai.axe.wkt import Point
from ai.axe.wkt import PolygonRing
from ai.axe.build.unittest import AxeSimpleTestCase
#
# Import statements go above this line.
#-------------------------------------------------------------------

#===================================================================
class TestPolygonRing(AxeSimpleTestCase):
  '''Unit test for the PolygonRing class.
'''

  #-----------------------------------------------------------------
  def setUp(self) -> None:

    # Put initialization code here.  It will be run before each test.
    pass

  #-----------------------------------------------------------------
  def tearDown(self) -> None:

    # Put finalization code here.  It will be run after each test.
    pass

  #-----------------------------------------------------------------
  def testCtor(self) -> None:
    '''Test creating.
    '''

    points = [Point(1, 2), Point(3, 4)]
    ring = PolygonRing(points)

    self.assertEqual(1, ring.points[0].x, "x")
    self.assertEqual(2, ring.points[0].y, "y")
    self.assertEqual(3, ring.points[1].x, "x")
    self.assertEqual(4, ring.points[1].y, "y")

    # Make sure no exception is thrown.
    str(ring)

    # Test equality.

    points = [Point(1, 1), Point(3, 4)]
    ring2 = PolygonRing(points)

    self.assertEqual(ring, ring)
    self.assertNotEqual(ring, ring2)
