#-------------------------------------------------------------------
#  TestPolygon.py
#
#  The TestPolygon module.
#
#  Copyright 2016 Applied Invention, LLC
#-------------------------------------------------------------------

'''Unit test for the Polygon class.
'''

#-------------------------------------------------------------------
# Import statements go here.
#
from ai.axe.wkt import Point
from ai.axe.wkt import PolygonRing
from ai.axe.wkt import Polygon
from ai.axe.build.unittest import AxeSimpleTestCase
#
# Import statements go above this line.
#-------------------------------------------------------------------

#===================================================================
class TestPolygon(AxeSimpleTestCase):
  '''Unit test for the Polygon class.
'''

  #-----------------------------------------------------------------
  def setUp(self) -> None:

    # Put initialization code here.  It will be run before each test.
    pass

  #-----------------------------------------------------------------
  def tearDown(self) -> None:

    # Put finalization code here.  It will be run after each test.
    pass

  #-----------------------------------------------------------------
  def testCtor(self) -> None:
    '''Test creating.
    '''

    points1 = [Point(1, 2), Point(3, 4)]
    points2 = [Point(5, 6), Point(7, 8)]
    rings = [PolygonRing(points1), PolygonRing(points2)]
    polygon = Polygon(rings)

    self.assertEqual(1, polygon.rings[0].points[0].x, "x")
    self.assertEqual(2, polygon.rings[0].points[0].y, "y")
    self.assertEqual(3, polygon.rings[0].points[1].x, "x")
    self.assertEqual(4, polygon.rings[0].points[1].y, "y")

    self.assertEqual(5, polygon.rings[1].points[0].x, "x")
    self.assertEqual(6, polygon.rings[1].points[0].y, "y")
    self.assertEqual(7, polygon.rings[1].points[1].x, "x")
    self.assertEqual(8, polygon.rings[1].points[1].y, "y")

    # Make sure no exception is thrown.
    str(polygon)

    # Test equality.

    points1 = [Point(1, 1), Point(3, 4)]
    points2 = [Point(5, 6), Point(7, 8)]
    rings = [PolygonRing(points1), PolygonRing(points2)]
    polygon2 = Polygon(rings)

    self.assertEqual(polygon, polygon)
    self.assertNotEqual(polygon, polygon2)
    self.assertNotEqual(polygon, "Wrong type of object.  Not a Polygon.")

    # Test copy.

    oldPolygon = polygon
    polygon = oldPolygon.createCopy()

    self.assertTrue(polygon is not oldPolygon)

    self.assertEqual(1, polygon.rings[0].points[0].x, "x")
    self.assertEqual(2, polygon.rings[0].points[0].y, "y")
    self.assertEqual(3, polygon.rings[0].points[1].x, "x")
    self.assertEqual(4, polygon.rings[0].points[1].y, "y")

    self.assertEqual(5, polygon.rings[1].points[0].x, "x")
    self.assertEqual(6, polygon.rings[1].points[0].y, "y")
    self.assertEqual(7, polygon.rings[1].points[1].x, "x")
    self.assertEqual(8, polygon.rings[1].points[1].y, "y")

  #-----------------------------------------------------------------
  def testRectangleCtor(self) -> None:
    '''Test creating a rectangle.
    '''

    upperLeft = (3, 4)
    lowerRight = (7, 1)

    polygon = Polygon.createRectangle(upperLeft, lowerRight)

    self.assertEqual(3, polygon.rings[0].points[0].x, "0 x")
    self.assertEqual(4, polygon.rings[0].points[0].y, "0 y")
    self.assertEqual(7, polygon.rings[0].points[1].x, "1 x")
    self.assertEqual(4, polygon.rings[0].points[1].y, "1 y")
    self.assertEqual(7, polygon.rings[0].points[2].x, "2 x")
    self.assertEqual(1, polygon.rings[0].points[2].y, "2 y")
    self.assertEqual(3, polygon.rings[0].points[3].x, "3 x")
    self.assertEqual(1, polygon.rings[0].points[3].y, "3 y")
    self.assertEqual(3, polygon.rings[0].points[4].x, "4 x")
    self.assertEqual(4, polygon.rings[0].points[4].y, "4 y")

  #-----------------------------------------------------------------
  def testPointsCtor(self) -> None:
    '''Test creating a from points.
    '''

    points = (
      (3, 4),
      (7, 4),
      (7, 1),
      (3, 1),
      (3, 4),
      )

    polygon = Polygon.createFromPoints(points)

    self.assertEqual(3, polygon.rings[0].points[0].x, "0 x")
    self.assertEqual(4, polygon.rings[0].points[0].y, "0 y")
    self.assertEqual(7, polygon.rings[0].points[1].x, "1 x")
    self.assertEqual(4, polygon.rings[0].points[1].y, "1 y")
    self.assertEqual(7, polygon.rings[0].points[2].x, "2 x")
    self.assertEqual(1, polygon.rings[0].points[2].y, "2 y")
    self.assertEqual(3, polygon.rings[0].points[3].x, "3 x")
    self.assertEqual(1, polygon.rings[0].points[3].y, "3 y")
    self.assertEqual(3, polygon.rings[0].points[4].x, "4 x")
    self.assertEqual(4, polygon.rings[0].points[4].y, "4 y")

  #-----------------------------------------------------------------
  def testMath(self) -> None:
    '''Test the math() methods.
    '''

    points1 = [Point(1, 2), Point(3, 4)]
    rings = [PolygonRing(points1)]
    polygon = Polygon(rings)

    polygon = polygon.subtract(Point(1, 2))

    self.assertEqual(0, polygon.rings[0].points[0].x, "x")
    self.assertEqual(0, polygon.rings[0].points[0].y, "y")
    self.assertEqual(2, polygon.rings[0].points[1].x, "x")
    self.assertEqual(2, polygon.rings[0].points[1].y, "y")

    polygon = polygon.add(Point(3, 2))

    self.assertEqual(3, polygon.rings[0].points[0].x, "x")
    self.assertEqual(2, polygon.rings[0].points[0].y, "y")
    self.assertEqual(5, polygon.rings[0].points[1].x, "x")
    self.assertEqual(4, polygon.rings[0].points[1].y, "y")

    polygon = polygon.multiply(Point(2, 3))

    self.assertEqual(6, polygon.rings[0].points[0].x, "x")
    self.assertEqual(6, polygon.rings[0].points[0].y, "y")
    self.assertEqual(10, polygon.rings[0].points[1].x, "x")
    self.assertEqual(12, polygon.rings[0].points[1].y, "y")

    polygon = polygon.divide(Point(2, 2))

    self.assertEqual(3, polygon.rings[0].points[0].x, "x")
    self.assertEqual(3, polygon.rings[0].points[0].y, "y")
    self.assertEqual(5, polygon.rings[0].points[1].x, "x")
    self.assertEqual(6, polygon.rings[0].points[1].y, "y")
