#-------------------------------------------------------------------
#  TestPoint3d.py
#
#  The TestPoint3d module.
#
#  Copyright 2016 Applied Invention, LLC
#-------------------------------------------------------------------

'''Unit test for the Point3d class.
'''

#-------------------------------------------------------------------
# Import statements go here.
#
from ai.axe.wkt import Point3d
from ai.axe.build.unittest import AxeSimpleTestCase
#
# Import statements go above this line.
#-------------------------------------------------------------------

#===================================================================
class TestPoint3d(AxeSimpleTestCase):
  '''Unit test for the Point3d class.
'''

  #-----------------------------------------------------------------
  def setUp(self):

    # Put initialization code here.  It will be run before each test.
    pass

  #-----------------------------------------------------------------
  def tearDown(self):

    # Put finalization code here.  It will be run after each test.
    pass

  #-----------------------------------------------------------------
  def testCtor(self) -> None:
    '''Test creating.
    '''

    point = Point3d(1, 2, 3)
    self.assertEqual(1, point.x, "x")
    self.assertEqual(2, point.y, "y")
    self.assertEqual(3, point.z, "z")

    # Make sure no exception is thrown.
    str(point)

    # Test equality.

    point2 = Point3d(1, 1, 1)

    self.assertEqual(point, point)
    self.assertNotEqual(point, point2)

  #-----------------------------------------------------------------
  def testIsCloseTo(self) -> None:
    '''Test the isCloseTo() method.
    '''

    assertClose = self.assertIsCloseTo

    assertClose(True, Point3d(30, 40, -20), Point3d(30, 40, -20))
    assertClose(True, Point3d(30, 40, -20.000009), Point3d(30, 40, -20))
    assertClose(True, Point3d(30, 40.000009, -20), Point3d(30, 40, -20))
    assertClose(True, Point3d(30.000009, 40, -20), Point3d(30, 40, -20))
    assertClose(False, Point3d(30, 40, -20.00002), Point3d(30, 40, -20))
    assertClose(False, Point3d(30, 40.00002, -20), Point3d(30, 40, -20))
    assertClose(False, Point3d(30.00002, 40, -20), Point3d(30, 40, -20))

  #-----------------------------------------------------------------
  def testImmutability(self) -> None:
    '''Test values can not be changed.
    '''
    # Pylint seems to think TypeError doesn't have a 'message' member.
    # pylint: disable=E1101

    point = Point3d(1, 2, 3)

    try:
      point.z = 4
      self.fail("No exception for setting immutable value.")

    except TypeError as e:
      expected = "Attempted to change a value, but Point3d is immutable.  z=4"
      self.assertEqual(expected, str(e))

  #-----------------------------------------------------------------
  def testMath(self) -> None:
    '''Tests the arithmetic functions.
    '''

    point = Point3d(1, 2, 3)

    point = point.subtract(Point3d(3, 5, 7))

    self.assertEqual(-2, point.x, "x")
    self.assertEqual(-3, point.y, "y")
    self.assertEqual(-4, point.z, "z")

    point = point.add(Point3d(7, 14, 21))

    self.assertEqual(5, point.x, "x")
    self.assertEqual(11, point.y, "y")
    self.assertEqual(17, point.z, "z")

    point = point.multiply(Point3d(10, 3, 2))

    self.assertEqual(50, point.x, "x")
    self.assertEqual(33, point.y, "y")
    self.assertEqual(34, point.z, "z")

    point = point.divide(Point3d(5, 3, 2))

    self.assertEqual(10, point.x, "x")
    self.assertEqual(11, point.y, "y")
    self.assertEqual(17, point.z, "z")

  #-----------------------------------------------------------------
  def assertIsCloseTo(self,
                      expected: bool,
                      point1: Point3d,
                      point2: Point3d) -> None:
    '''Helper function to test the isCloseTo() method.
    '''

    actual = point1.isCloseTo(point2)
    msg = "%s isCloseTo %s" % (point1, point2)

    self.assertEqual(expected, actual, msg)
