#-------------------------------------------------------------------
#  TestPoint.py
#
#  The TestPoint module.
#
#  Copyright 2016 Applied Invention, LLC
#-------------------------------------------------------------------

'''Unit test for the Point class.
'''

#-------------------------------------------------------------------
# Import statements go here.
#
from ai.axe.wkt import Point
from ai.axe.build.unittest import AxeSimpleTestCase
#
# Import statements go above this line.
#-------------------------------------------------------------------

#===================================================================
class TestPoint(AxeSimpleTestCase):
  '''Unit test for the Point class.
'''

  #-----------------------------------------------------------------
  def setUp(self):

    # Put initialization code here.  It will be run before each test.
    pass

  #-----------------------------------------------------------------
  def tearDown(self):

    # Put finalization code here.  It will be run after each test.
    pass

  #-----------------------------------------------------------------
  def testCtor(self) -> None:
    '''Test creating.
    '''

    point = Point(1, 2)
    self.assertEqual(1, point.x, "x")
    self.assertEqual(2, point.y, "y")

    # Make sure no exception is thrown.
    str(point)

    # Test equality.

    point2 = Point(1, 1)

    self.assertEqual(point, point)
    self.assertNotEqual(point, point2)

  #-----------------------------------------------------------------
  def testIsCloseTo(self) -> None:
    '''Test the isCloseTo() method.
    '''

    self.assertIsCloseTo(True, Point(40, -20), Point(40, -20))
    self.assertIsCloseTo(True, Point(40, -20.000009), Point(40, -20))
    self.assertIsCloseTo(True, Point(40.000009, -20), Point(40, -20))
    self.assertIsCloseTo(False, Point(40, -20.00002), Point(40, -20))
    self.assertIsCloseTo(False, Point(40.00002, -20), Point(40, -20))

  #-----------------------------------------------------------------
  def testImmutability(self) -> None:
    '''Test values can not be changed.
    '''
    # Pylint seems to think TypeError doesn't have a 'message' member.
    # pylint: disable=E1101

    point = Point(1, 2)

    try:
      point.x = 3
      self.fail("No exception for setting immutable value.")

    except TypeError as e:
      expected = "Attempted to change a value, but Point is immutable.  x=3"
      self.assertEqual(expected, str(e))

  #-----------------------------------------------------------------
  def testMath(self) -> None:
    '''Tests the arithmetic functions.
    '''

    point = Point(1, 2)

    point = point.subtract(Point(3, 5))

    self.assertEqual(-2, point.x, "x")
    self.assertEqual(-3, point.y, "y")

    point = point.add(Point(7, 14))

    self.assertEqual(5, point.x, "x")
    self.assertEqual(11, point.y, "y")

    point = point.multiply(Point(10, 3))

    self.assertEqual(50, point.x, "x")
    self.assertEqual(33, point.y, "y")

    point = point.divide(Point(5, 3))

    self.assertEqual(10, point.x, "x")
    self.assertEqual(11, point.y, "y")

  #-----------------------------------------------------------------
  def assertIsCloseTo(self,
                      expected: bool,
                      point1: Point,
                      point2: Point) -> None:
    '''Helper function to test the isCloseTo() method.
    '''

    actual = point1.isCloseTo(point2)
    msg = "%s isCloseTo %s" % (point1, point2)

    self.assertEqual(expected, actual, msg)
