#-------------------------------------------------------------------
#  TestMultiPolygon.py
#
#  The TestMultiPolygon module.
#
#  Copyright 2016 Applied Invention, LLC
#-------------------------------------------------------------------

'''Unit test for the MultiPolygon class.
'''

#-------------------------------------------------------------------
# Import statements go here.
#
from ai.axe.wkt import Point
from ai.axe.wkt import PolygonRing
from ai.axe.wkt import Polygon
from ai.axe.wkt import MultiPolygon
from ai.axe.build.unittest import AxeSimpleTestCase
#
# Import statements go above this line.
#-------------------------------------------------------------------

#===================================================================
class TestMultiPolygon(AxeSimpleTestCase):
  '''Unit test for the MultiPolygon class.
'''

  #-----------------------------------------------------------------
  def setUp(self) -> None:

    # Put initialization code here.  It will be run before each test.
    pass

  #-----------------------------------------------------------------
  def tearDown(self) -> None:

    # Put finalization code here.  It will be run after each test.
    pass

  #-----------------------------------------------------------------
  def testCtor(self) -> None:
    '''Test creating.
    '''

    points1 = [Point(1, 2), Point(3, 4)]
    points2 = [Point(5, 6), Point(7, 8)]
    rings = [PolygonRing(points1)]
    polygon1 = Polygon(rings)
    rings = [PolygonRing(points2)]
    polygon2 = Polygon(rings)
    mp = MultiPolygon([polygon1, polygon2])

    self.assertEqual(1, mp.polygons[0].rings[0].points[0].x, "x")
    self.assertEqual(2, mp.polygons[0].rings[0].points[0].y, "y")
    self.assertEqual(3, mp.polygons[0].rings[0].points[1].x, "x")
    self.assertEqual(4, mp.polygons[0].rings[0].points[1].y, "y")

    self.assertEqual(5, mp.polygons[1].rings[0].points[0].x, "x")
    self.assertEqual(6, mp.polygons[1].rings[0].points[0].y, "y")
    self.assertEqual(7, mp.polygons[1].rings[0].points[1].x, "x")
    self.assertEqual(8, mp.polygons[1].rings[0].points[1].y, "y")

    # Make sure no exception is thrown.
    str(mp)

    # Test equality.

    points1 = [Point(1, 1), Point(3, 4)]
    points2 = [Point(5, 6), Point(7, 8)]
    rings = [PolygonRing(points1)]
    polygon1 = Polygon(rings)
    rings = [PolygonRing(points2)]
    polygon2 = Polygon(rings)
    mp2 = MultiPolygon([polygon1, polygon2])

    self.assertEqual(mp, mp)
    self.assertNotEqual(mp, mp2)
    self.assertNotEqual(mp, "Wrong type of object.  Not a MultiPolygon.")

  #-----------------------------------------------------------------
  def testRectangleCtor(self) -> None:
    '''Test creating a rectangle.
    '''

    upperLeft = (3, 4)
    lowerRight = (7, 1)

    multiPolygon = MultiPolygon.createRectangle(upperLeft, lowerRight)

    polygon = multiPolygon.polygons[0]

    self.assertEqual(3, polygon.rings[0].points[0].x, "0 x")
    self.assertEqual(4, polygon.rings[0].points[0].y, "0 y")
    self.assertEqual(7, polygon.rings[0].points[1].x, "1 x")
    self.assertEqual(4, polygon.rings[0].points[1].y, "1 y")
    self.assertEqual(7, polygon.rings[0].points[2].x, "2 x")
    self.assertEqual(1, polygon.rings[0].points[2].y, "2 y")
    self.assertEqual(3, polygon.rings[0].points[3].x, "3 x")
    self.assertEqual(1, polygon.rings[0].points[3].y, "3 y")
    self.assertEqual(3, polygon.rings[0].points[4].x, "4 x")
    self.assertEqual(4, polygon.rings[0].points[4].y, "4 y")
