#-------------------------------------------------------------------
#  TestLineString.py
#
#  The TestLineString module.
#
#  Copyright 2016 Applied Invention, LLC
#-------------------------------------------------------------------

'''Unit test for the LineString class.
'''

#-------------------------------------------------------------------
# Import statements go here.
#
from ai.axe.wkt import Point
from ai.axe.wkt import LineString
from ai.axe.build.unittest import AxeSimpleTestCase
#
# Import statements go above this line.
#-------------------------------------------------------------------

#===================================================================
class TestLineString(AxeSimpleTestCase):
  '''Unit test for the LineString class.
'''

  #-----------------------------------------------------------------
  def setUp(self) -> None:

    # Put initialization code here.  It will be run before each test.
    pass

  #-----------------------------------------------------------------
  def tearDown(self) -> None:

    # Put finalization code here.  It will be run after each test.
    pass

  #-----------------------------------------------------------------
  def testCtor(self) -> None:
    '''Test creating.
    '''

    points = [Point(1, 2), Point(3, 4)]
    line = LineString(points)

    self.assertEqual(1, line.points[0].x, "x")
    self.assertEqual(2, line.points[0].y, "y")
    self.assertEqual(3, line.points[1].x, "x")
    self.assertEqual(4, line.points[1].y, "y")

    # Make sure no exception is thrown.
    str(line)

    # Test equality.

    points = [Point(1, 1), Point(3, 4)]
    line2 = LineString(points)

    self.assertEqual(line, line)
    self.assertNotEqual(line, line2)
