#-------------------------------------------------------------------
#  TestEsriPolygon.py
#
#  The TestEsriPolygon module.
#
#  Copyright 2014 Applied Invention, LLC.
#-------------------------------------------------------------------

'''Unit test for the EsriPolygon class.
'''

#-------------------------------------------------------------------
# Import statements go here.
#
from ai.axe.build.unittest import AxeSimpleTestCase
from ai.axe.wkt import EsriPolygon
from ai.axe.wkt import MultiPolygon
from ai.axe.wkt import Point
from ai.axe.wkt import Polygon
from ai.axe.wkt import PolygonRing
#
# Import statements go above this line.
#-------------------------------------------------------------------

#===================================================================
class TestEsriPolygon(AxeSimpleTestCase):
  '''Unit test for the EsriPolygon class.
'''

  #-----------------------------------------------------------------
  def setUp(self) -> None:

    # Put initialization code here.  It will be run before each test.
    pass

  #-----------------------------------------------------------------
  def tearDown(self) -> None:

    # Put finalization code here.  It will be run after each test.
    pass

  #-----------------------------------------------------------------
  def testCreateFromPolygon(self) -> None:
    '''Create an EsriPolygon from a Polygon.
    '''

    srcXy = [(0.1, 0.1), (0.2, 0.1), (0.2, 0.2), (0.1, 0.2), (0.1, 0.1)]
    srcPoints = [Point(x, y) for x, y in srcXy]

    srcPolygon = Polygon([PolygonRing(srcPoints)])

    # Create from Polygon object.

    polygon = EsriPolygon.fromPolygon(srcPolygon)

    self.assertEqual(srcXy, polygon.rings[0], "polygon")

    # Create from MultiPolygon object.

    polygon = EsriPolygon.fromPolygon(MultiPolygon([srcPolygon]))

    self.assertEqual(srcXy, polygon.rings[0], "multi polygon")

    # Check that string conversion doesn't throw an exception.
    str(polygon)

  #-----------------------------------------------------------------
  def testError(self) -> None:
    '''Create an EsriPolygon from Polygon.
    '''

    try:
      EsriPolygon.fromPolygon(3)
      self.fail("Failed to throw exception")
    except TypeError:
      pass
