#-------------------------------------------------------------------
#  WktUtil.py
#
#  The WktUtil class.
#
#  Copyright 2014 Applied Invention, LLC.
#-------------------------------------------------------------------

'''The module containing the WktUtil class.
'''

#-------------------------------------------------------------------
# Import statements go here.
#
from .GeoShape import GeoShape
from .WktReader import WktReader
from .WktWriter import WktWriter
from ai.axe.util import StringUtil
from typing import cast
from typing import Dict
from typing import List
from typing import TypeVar
#
# Import statements go above this line.
#-------------------------------------------------------------------

#-------------------------------------------------------------------
GeoClass = TypeVar('GeoClass', bound=GeoShape)

#===================================================================
class WktUtil:
  '''Geospacial utility functions.
  '''

  #-----------------------------------------------------------------
  def __init__(self) -> None:
    '''Creates a new WktUtil.
    '''

    pass

  #-----------------------------------------------------------------
  @staticmethod
  def toWebMercator(session, geometry: GeoClass) -> GeoClass:
    '''Converts a geometry object to another object in Web Mercator coordinates.

    @param session The DB to use to do the conversion.
    @param geometry The geometry object (such as Polygon) to convert.

    @return An object of the same class that was passed in.
    '''

    geometryText = WktWriter().write(geometry)

    sql = "select ST_AsText(ST_Transform(ST_GeomFromText('%s', 4326), 3785))"
    sql = sql % geometryText

    params: Dict[str, object] = {}

    row = session.execute(sql, params).fetchall()[0]
    newText = row[0]

    newGeometry = WktReader().read(newText)

    return cast(GeoClass, newGeometry)

  #----------------------------------------------------------------
  def __repr__(self) -> str:
    '''Returns a string representation of this object
    '''
    attrs: List[str] = []

    return StringUtil.formatRepr(self, attrs)
