#-------------------------------------------------------------------
#  PolygonRing.py
#
#  The PolygonRing class.
#
#  Copyright 2016 Applied Invention, LLC
#-------------------------------------------------------------------

'''The module containing the PolygonRing class.
'''

#-------------------------------------------------------------------
# Import statements go here.
#
from .GeoShape import GeoShape
from .Point import Point
from ai.axe.util import StringUtil
from typing import List
#
# Import statements go above this line.
#-------------------------------------------------------------------


#===================================================================
class PolygonRing(GeoShape):
  '''A single ring in a polygon.  A list of (x, y) points.
  '''

  #-----------------------------------------------------------------
  def __init__(self, points: List[Point]) -> None:
    '''Creates a new PolygonRing.

    @param points A list of Point objects that define a border.
    '''

    GeoShape.__init__(self)

    assert isinstance(points, (list, tuple)), points
    for i, point in enumerate(points):
      assert isinstance(point, Point), (i, point)

    # A list of Point objects that define a border.
    self.points = points

  #-----------------------------------------------------------------
  def __eq__(self, other: object) -> bool:
    '''Support the == operator.
    '''

    if not isinstance(other, PolygonRing):
      return False

    return self.points == other.points

  #-----------------------------------------------------------------
  def __repr__(self) -> str:
    '''Formats this object into a string.
    '''

    attrs = ['points']
    return StringUtil.formatRepr(self, attrs)
