#-------------------------------------------------------------------
#  MultiPolygon.py
#
#  The MultiPolygon class.
#
#  Copyright 2016 Applied Invention, LLC
#-------------------------------------------------------------------

'''The module containing the MultiPolygon class.
'''

#-------------------------------------------------------------------
# Import statements go here.
#
from ai.axe.util import StringUtil
from .Polygon import Polygon
from .GeoShape import GeoShape
from typing import List
from typing import Tuple
#
# Import statements go above this line.
#-------------------------------------------------------------------


#===================================================================
class MultiPolygon(GeoShape):
  '''A WKT MultiPolygon, made of up a list of polygons.
  '''

  #-----------------------------------------------------------------
  def __init__(self, polygons: List[Polygon]) -> None:
    '''Creates a new MultiPolygon.

    @param polygons A list of Polygon objects that defines the areas
                    that make up this geometry object.
    '''

    GeoShape.__init__(self)

    # A list of Polygons objects that defines the areas
    # that make up this geometry object.
    self.polygons = polygons

  #-----------------------------------------------------------------
  @staticmethod
  def createRectangle(upperLeftXy: Tuple[float, float],
                      lowerRightXy: Tuple[float, float]) -> 'MultiPolygon':
    '''Creates a new polygon that is a rectangle.

    @param upperLeftXy The upper left corner of the created rectangle.
    @param lowerRightXy The lower right corner of the created rectangle.

    @return A newly created Polygon.
    '''

    polygons = [Polygon.createRectangle(upperLeftXy, lowerRightXy)]

    return MultiPolygon(polygons)

  #-----------------------------------------------------------------
  def __eq__(self, other: object) -> bool:
    '''Support the == operator.
    '''

    if not hasattr(other, 'polygons'):
      return False

    return self.polygons == getattr(other, 'polygons')

  #-----------------------------------------------------------------
  def __repr__(self) -> str:
    '''Formats this object into a string.
    '''

    attrs = ['polygons']
    return StringUtil.formatRepr(self, attrs)
