#-------------------------------------------------------------------
#  LineString.py
#
#  The LineString class.
#
#  Copyright 2016 Applied Invention, LLC
#-------------------------------------------------------------------

'''The module containing the LineString class.
'''

#-------------------------------------------------------------------
# Import statements go here.
#
from .Point import Point
from .PolygonRing import PolygonRing
from ai.axe.util import StringUtil
from typing import List
#
# Import statements go above this line.
#-------------------------------------------------------------------


#===================================================================
class LineString(PolygonRing):
  '''A line.  A list of (x, y) points.
  '''

  #-----------------------------------------------------------------
  def __init__(self, points: List[Point]) -> None:
    '''Creates a new LineString.

    @param points A list of Point objects that define a line.
    '''

    PolygonRing.__init__(self, points)

  #-----------------------------------------------------------------
  def __eq__(self, other: object) -> bool:
    '''Support the == operator.
    '''

    if not isinstance(other, LineString):
      return False

    return self.points == other.points

  #-----------------------------------------------------------------
  def __repr__(self) -> str:
    '''Formats this object into a string.
    '''

    attrs = ['points']
    return StringUtil.formatRepr(self, attrs)
