#-------------------------------------------------------------------
#  EsriSpatialReference.py
#
#  The EsriSpatialReference class.
#
#  Copyright 2014 Applied Invention, LLC.
#-------------------------------------------------------------------

'''The module containing the EsriSpatialReference class.
'''

#-------------------------------------------------------------------
# Import statements go here.
#
from ai.axe.classJson import ClassJsonClass
from ai.axe.classJson import ClassJsonField
from ai.axe.util import StringUtil
#
# Import statements go above this line.
#-------------------------------------------------------------------


#===================================================================
@ClassJsonClass([ClassJsonField('wkid', int)],
                encodeOnly=True)
class EsriSpatialReference:
  '''A Python equivalent to the ESRI Javascript SpatialReference class.
  '''

  #-----------------------------------------------------------------
  def __init__(self, wkid: int) -> None:
    '''Creates a new EsriSpatialReference.
    '''

    # The well-known ID of the reference frame.
    self.wkid = wkid

  #----------------------------------------------------------------
  def __repr__(self) -> str:
    '''Returns a string representation of this object
    '''
    attrs = ['wkid']

    return StringUtil.formatRepr(self, attrs)
