#-------------------------------------------------------------------
#  AppVersionClass.py
#
#  The AppVersionClass module.
#
#  Copyright 2017 Applied Invention, LLC
#-------------------------------------------------------------------

'''Access module for the AppVersion class.

Because SqlBase is not available at import time, we have to defer
class creation until run time, when an AppSetup has been registered
and SqlBase is available.

Therefore, you must call AppVersionClass.get() to get the class rather
than just using AppVersion.
'''

#-------------------------------------------------------------------
# Import statements go here.
#

#
# Import statements go above this line.
#-------------------------------------------------------------------


#-------------------------------------------------------------------
def get():
  '''Returns the AppVersion class.
  '''

  # pylint: disable=import-outside-toplevel
  from .AppVersion import AppVersion

  return AppVersion
