#-------------------------------------------------------------------
#  AppVersion.py
#
#  The AppVersion class.
#
#  Copyright 2017 Applied Invention, LLC
#-------------------------------------------------------------------

'''The module containing the AppVersion class.
'''

#-------------------------------------------------------------------
# Import statements go here.
#
from ai.axe.db.alchemy import Column
from ai.axe.web.app import AppSetup
from ai.axe.util import StringUtil
from typing import Any
#
# Import statements go above this line.
#-------------------------------------------------------------------


#-------------------------------------------------------------------
# Because SqlBase is not available at import time, we have to defer
# class creation until run time, when an AppSetup has been registered
# and SqlBase is available.
#
# Therefore, you must call AppVersionClass.get() to get the class
# rather than just using AppVersion.

#-------------------------------------------------------------------
sqlBase: Any = AppSetup.get().sqlBase()

#===================================================================
class AppVersion(sqlBase):
  '''The the version of the application that is currently installed.
  '''

  # The database ID.
  id = Column(int, primary_key=True)

  # The application version.
  appVersion = Column(str)

  # The database schema version.
  dbVersion = Column(str)

  #-----------------------------------------------------------------
  def __init__(self, appVersion, dbVersion):
    '''Creates a new AppVersion.
    '''

    self.id = None
    self.appVersion = appVersion
    self.dbVersion = dbVersion

  #----------------------------------------------------------------
  def __repr__(self):
    '''Returns a string representation of this object
    '''
    attrs = ['appVersion', 'dbVersion']

    return StringUtil.formatRepr(self, attrs)
