#-------------------------------------------------------------------
#  TestLogConfig.py
#
#  The TestLogConfig module.
#
#  Copyright 2017 Applied Invention, LLC
#-------------------------------------------------------------------

'''Unit test for the LogConfig class.
'''

#-------------------------------------------------------------------
# Import statements go here.
#
from ai.axe.build.unittest import AxeSimpleTestCase
from ai.axe.web.config import LogConfig
#
# Import statements go above this line.
#-------------------------------------------------------------------

#===================================================================
class TestLogConfig(AxeSimpleTestCase):
  '''Unit test for the LogConfig class.
  '''

  #-----------------------------------------------------------------
  def setUp(self) -> None:

    # Put initialization code here.  It will be run before each test.
    pass

  #-----------------------------------------------------------------
  def tearDown(self) -> None:

    # Put finalization code here.  It will be run after each test.
    pass

  #-----------------------------------------------------------------
  def testCtor(self) -> None:
    '''Test creating an object.
    '''

    config = LogConfig('a', 'b', False, True)
    self.assertEqual('a', config.webDir, 'webDir')
    self.assertEqual('b', config.commandDir, 'commandDir')
    self.assertEqual(False, config.debug, 'debug')
    self.assertEqual(True, config.sql, 'sql')

  #-----------------------------------------------------------------
  def testKeys(self) -> None:
    '''Test that the returned keys are correct.
    '''

    keys = LogConfig.configKeys()

    for i, keyInfo in enumerate(keys):
      self.assertEqual(3, len(keyInfo), i)
