#-------------------------------------------------------------------
#  TestDbConfig.py
#
#  The TestDbConfig module.
#
#  Copyright 2017 Applied Invention, LLC
#-------------------------------------------------------------------

'''Unit test for the DbConfig class.
'''

#-------------------------------------------------------------------
# Import statements go here.
#
from ai.axe.build.unittest import AxeSimpleTestCase
from ai.axe.web.config import DbConfig
#
# Import statements go above this line.
#-------------------------------------------------------------------

#===================================================================
class TestDbConfig(AxeSimpleTestCase):
  '''Unit test for the DbConfig class.
  '''

  #-----------------------------------------------------------------
  def setUp(self) -> None:

    # Put initialization code here.  It will be run before each test.
    pass

  #-----------------------------------------------------------------
  def tearDown(self) -> None:

    # Put finalization code here.  It will be run after each test.
    pass

  #-----------------------------------------------------------------
  def testUnitTestConfig(self) -> None:
    '''Test generating a unit test config.
    '''

    url = 'postgresql+psycopg2://ramwebapp:ramwebapp@foo.com:1111/ramwebapp'
    baseConfig = DbConfig(url, False, 1, 2, 3, 4)

    expected = ('postgresql+psycopg2://ramwebapp:ramwebapp@' +
                'localhost:5432/ramtest')
    actual = baseConfig.unitTestConfig().url

    self.assertEqual(expected, actual, 'url')


    # For a DB name that doesn't end in 'webapp', just append 'test'.

    url = 'postgresql+psycopg2://ramwebapp:ramwebapp@foo.com:1111/foo'
    baseConfig = DbConfig(url, False, 1, 2, 3, 4)

    expected = ('postgresql+psycopg2://ramwebapp:ramwebapp@' +
                'localhost:5432/footest')
    actual = baseConfig.unitTestConfig().url

    self.assertEqual(expected, actual, 'url')


    # Allow unit tests on remote machines.

    remoteUnitTests = True

    url = 'postgresql+psycopg2://ramwebapp:ramwebapp@foo.com:1111/ramwebapp'
    baseConfig = DbConfig(url, remoteUnitTests, 1, 2, 3, 4)

    expected = ('postgresql+psycopg2://ramwebapp:ramwebapp@' +
                'foo.com:1111/ramtest')
    actual = baseConfig.unitTestConfig().url

    self.assertEqual(expected, actual, 'url')

  #-----------------------------------------------------------------
  def testKeys(self) -> None:
    '''Test that the returned keys are correct.
    '''

    keys = DbConfig.configKeys()

    for i, keyInfo in enumerate(keys):
      self.assertEqual(3, len(keyInfo), i)
