#-------------------------------------------------------------------
#  TestConfigParser.py
#
#  The TestConfigParser module.
#
#  Copyright 2016 Applied Invention, LLC
#-------------------------------------------------------------------

'''Unit test for the ConfigParser class.
'''

#-------------------------------------------------------------------
# Import statements go here.
#
from ai.axe.web.core import AxeException
from ai.axe.web.config import ConfigParser
from ai.axe.build.unittest import AxeSimpleTestCase
#
# Import statements go above this line.
#-------------------------------------------------------------------

#===================================================================
class TestConfigParser(AxeSimpleTestCase):
  '''Unit test for the ConfigParser class.
  '''

  #-----------------------------------------------------------------
  def setUp(self) -> None:

    # Put initialization code here.  It will be run before each test.
    pass

  #-----------------------------------------------------------------
  def tearDown(self) -> None:

    # Put finalization code here.  It will be run after each test.
    pass

  #-----------------------------------------------------------------
  def testBasicParser(self) -> None:
    '''Test basic parsing functionality.
    '''

    parser = ConfigParser()

    text = r'''# Config file.

x = 1

# Comment.
y=2  
a=
b  = 
# This is a comment because it's at the start of a line.
c = # Value, not comment.
d = Line 1\
Line 2\
Line 3

 z = What do you think? '''

    data = parser.parse(text)

    self.assertEqual('', data['a'], 'a')
    self.assertEqual('', data['b'], 'b')
    self.assertEqual('# Value, not comment.', data['c'], 'c')
    self.assertEqual('Line 1\nLine 2\nLine 3', data['d'], 'd')
    self.assertEqual('1', data['x'], 'x')
    self.assertEqual('2', data['y'], 'y')
    self.assertEqual('What do you think?', data['z'], 'z')

  #-----------------------------------------------------------------
  def testIllegalComment(self) -> None:
    '''Test an exception gets thrown for a comment in the wrong place.
    '''

    parser = ConfigParser()

    text = 'foo # comment'

    try:
      parser.parse(text)
      self.fail('No exception for bad comment.')
    except AxeException:
      pass

  #-----------------------------------------------------------------
  def testIllegalTextAfterKey(self) -> None:
    '''Test an exception gets thrown for text after a key.
    '''

    parser = ConfigParser()

    text = 'foo foo'

    try:
      parser.parse(text)
      self.fail('No exception for bad comment.')
    except AxeException:
      pass


  #-----------------------------------------------------------------
  def testNoEquals(self) -> None:
    '''Test an exception gets thrown for no equals sign after a key.
    '''

    parser = ConfigParser()

    # Trailing space.

    text = 'foo '

    try:
      parser.parse(text)
      self.fail('No exception for missing equals - trailing space.')
    except AxeException:
      pass

    # No trailing space.

    text = 'foo'

    try:
      parser.parse(text)
      self.fail('No exception for missing equals - no trailing space.')
    except AxeException:
      pass
