#-------------------------------------------------------------------
#  WebConfig.py
#
#  The WebConfig class.
#
#  Copyright 2016 Applied Invention, LLC
#-------------------------------------------------------------------

'''The module containing the WebConfig class.
'''

#-------------------------------------------------------------------
# Import statements go here.
#
from .ConfigSection import ConfigSection
from .ConfigTypes import ConfigValueType
from typing import Iterable
from typing import Tuple
#
# Import statements go above this line.
#-------------------------------------------------------------------


#===================================================================
class WebConfig(ConfigSection):
  '''Web configuration information.
  '''

  #-----------------------------------------------------------------
  def __init__(self, sessionTimeOut: int) -> None:
    '''Creates a new WebConfig.
    '''

    ConfigSection.__init__(self)

    # How much time before a user session times out.
    self.sessionTimeOut: int = sessionTimeOut

  #-----------------------------------------------------------------
  @staticmethod
  def configKeys() -> Iterable[Tuple[str, ConfigValueType, bool]]:
    '''Returns a list of those keys that must be present in the config file.

    If a required (isOptional=False) key is missing from the config file,
    the app will throw an error when the config file is read.

    @return A list of (keyName, type, isOptional) tuples, where:
            'keyName' is the string name of the key as it must appear
                      in the file;
            'type' is one of: int, str, bool, list;
            'isOptional' is a boolean: if False the key must be in the file,
                         if True the key may be absent.
    '''

    keys = (
      ('sessionTimeOut', int, False),
      )

    return keys
