#-------------------------------------------------------------------
#  LogConfig.py
#
#  The LogConfig class.
#
#  Copyright 2016 Applied Invention, LLC
#-------------------------------------------------------------------

'''The module containing the LogConfig class.
'''

#-------------------------------------------------------------------
# Import statements go here.
#
from .ConfigSection import ConfigSection
from .ConfigTypes import ConfigValueType
from typing import Iterable
from typing import Tuple
#
# Import statements go above this line.
#-------------------------------------------------------------------


#===================================================================
class LogConfig(ConfigSection):
  '''Logging configuration information.
  '''

  #-----------------------------------------------------------------
  def __init__(self,
               webDir: str,
               commandDir: str,
               debug: bool,
               sql: bool) -> None:
    '''Creates a new LogConfig.
    '''

    ConfigSection.__init__(self)

    # The directory to create web server logs in.
    self.webDir: str = webDir

    # The directory to put command-line utility logs in.
    self.commandDir: str = commandDir

    # Whether debug logging is enabled.
    self.debug: bool = debug

    # Whether logging of SQL statements is enabled.
    self.sql: bool = sql

  #-----------------------------------------------------------------
  @staticmethod
  def configKeys() -> Iterable[Tuple[str, ConfigValueType, bool]]:
    '''Returns a list of those keys that must be present in the config file.

    If a required (isOptional=False) key is missing from the config file,
    the app will throw an error when the config file is read.

    @return A list of (keyName, type, isOptional) tuples, where:
            'keyName' is the string name of the key as it must appear
                      in the file;
            'type' is one of: int, str, bool, list;
            'isOptional' is a boolean: if False the key must be in the file,
                         if True the key may be absent.
    '''

    keys = (
      ('webDir', str, False),
      ('commandDir', str, False),
      ('debug', bool, False),
      ('sql', bool, False),
      )

    return keys
