#-------------------------------------------------------------------
#  ConfigTypes.py
#
#  The ConfigTypes module.
#
#  Copyright 2018 Applied Invention, LLC
#-------------------------------------------------------------------

'''Types that are used in the config package.
'''

#-------------------------------------------------------------------
# Import statements go here.
#
from typing import Type
from typing import Union
#
# Import statements go above this line.
#-------------------------------------------------------------------


#===================================================================
# The type objects that can be used to specify the type of a value.
ConfigValueType = Union[Type[int], Type[str], Type[bool], Type[list]]

#===================================================================
# A config value.
ConfigValue = Union[int, str, bool, list]
