#-------------------------------------------------------------------
#  ConfigSection.py
#
#  The ConfigSection class.
#
#  Copyright 2017 Applied Invention, LLC
#-------------------------------------------------------------------

'''The module containing the ConfigSection class.
'''

#-------------------------------------------------------------------
# Import statements go here.
#
from .ConfigTypes import ConfigValueType
from typing import Iterable
from typing import Tuple
#
# Import statements go above this line.
#-------------------------------------------------------------------


#===================================================================
class ConfigSection:
  '''One section of the config file.

  To add a section to your app's config file, you should make
  a ConfigSection subclass.

  The subclass should implement the configKeys() method
  to allow the config file to be validated.

  The subclass' __init__() should take each key as an argument. Those
  keys which have isOptional=True should be given default values in
  the argument list.  Each argument should be assigned to a data
  member.
  '''

  #-----------------------------------------------------------------
  def __init__(self) -> None:
    '''Creates a new ConfigSection.
    '''

    pass

  #-----------------------------------------------------------------
  @staticmethod
  def configKeys() -> Iterable[Tuple[str, ConfigValueType, bool]]:
    '''Returns a list of those keys that must be present in the config file.

    If a required (isOptional=False) key is missing from the config file,
    the app will throw an error when the config file is read.

    @return A list of (keyName, type, isOptional) tuples, where:
            'keyName' is the string name of the key as it must appear
                      in the file;
            'type' is one of: int, str, bool, list;
            'isOptional' is a boolean: if False the key must be in the file,
                         if True the key may be absent.
    '''

    raise NotImplementedError()
