#-------------------------------------------------------------------
#  DropSchema.py
#
#  The DropSchema module.
#
#  Copyright 2016 Applied Invention, LLC
#-------------------------------------------------------------------

'''The DropSchema command.
'''

#-------------------------------------------------------------------
# Import statements go here.
#
from .AxeCommand import AxeCommand
from .AxeCommandBase import AxeCommandBase
from ai.axe.db import DbUtil
from io import StringIO
from sqlalchemy.orm.session import Session
from typing import List
import sys
#
# Import statements go above this line.
#-------------------------------------------------------------------


#===================================================================
@AxeCommand()
class DropSchema(AxeCommandBase):
  '''The DropSchema command object.
  '''

  #-----------------------------------------------------------------
  name = 'dropSchema'

  #-----------------------------------------------------------------
  description = 'Drops the tables of the schema.'

  #-----------------------------------------------------------------
  usage = '''dropSchema

Drops all the tables of the database schema.

To avoid accidentally writing to the database, nothing will be done
without the '-run' flag.
'''

  #---------------------------------------------------------------
  def run(self,
          session: Session,
          args: List[str],
          wantsTabCompletion: bool) -> None:

    if wantsTabCompletion:
      print("-run -q")
      return

    doDrop = False
    verbose = True

    for arg in args:
      if arg == '-run':
        doDrop = True
      elif arg == '-q':
        verbose = False
      else:
        print('Unknown commmand argument: %s' % arg)
        sys.exit(1)

    statusOut = sys.stdout if verbose else StringIO()

    # We used to do:
    #
    #   SqlBase.metadata.drop_all(session.bind)
    #
    # but this doesn't drop any old tables that aren't part of the current
    # version of the schema.

    DbUtil.findAndDropAllTables(session, doDrop, statusOut)

    if not doDrop:
      print()
      print("No changes made because '-run' flag not provided.")
