#-------------------------------------------------------------------
#  CreateSchema.py
#
#  The CreateSchema module.
#
#  Copyright 2016 Applied Invention, LLC
#-------------------------------------------------------------------

'''The CreateSchema command.
'''

#-------------------------------------------------------------------
# Import statements go here.
#
from .AxeCommand import AxeCommand
from .AxeCommandBase import AxeCommandBase
from ai.axe.web.app import AppSetup
from sqlalchemy.schema import MetaData
from sqlalchemy.orm.session import Session
from typing import List
#
# Import statements go above this line.
#-------------------------------------------------------------------


#===================================================================
@AxeCommand()
class CreateSchema(AxeCommandBase):
  '''The CreateSchema command object.
  '''

  #-----------------------------------------------------------------
  name = 'createSchema'

  #-----------------------------------------------------------------
  description = 'Creates the tables of the schema.'

  #-----------------------------------------------------------------
  usage = '''createSchema [-q] [-run]

Creates all the tables of the database schema.

To avoid accidentally writing to the database, nothing will be done
without the '-run' flag.

Normally, the DDL SQL is written to stdout.  The '-q' flag prevents this.
'''

  #---------------------------------------------------------------
  def run(self,
          session: Session,
          args: List[str],
          wantsTabCompletion: bool) -> None:

    if wantsTabCompletion:
      print("-run -q")
      return

    hasRun = '-run' in args
    isVerbose = '-q' not in args

    databaseMgr = AppSetup.get().databaseMgr()

    if isVerbose:
      print(databaseMgr.generateDdl())

    if hasRun:
      print('Creating tables...')

      sqlBase = databaseMgr.sqlBase
      metadata: MetaData = sqlBase.metadata # type: ignore

      metadata.create_all(session.bind)
