#-------------------------------------------------------------------
#  AxeCommandBase.py
#
#  The AxeCommandBase class.
#
#  Copyright 2018 Applied Invention, LLC
#-------------------------------------------------------------------

'''The module containing the AxeCommandBase class.
'''

#-------------------------------------------------------------------
# Import statements go here.
#

#
# Import statements go above this line.
#-------------------------------------------------------------------


#===================================================================
class AxeCommandBase:
  '''Base class that all commands must extend.
  '''

  #-----------------------------------------------------------------
  name = 'must be overridden'

  #-----------------------------------------------------------------
  description = 'must be overridden'

  #-----------------------------------------------------------------
  usage = 'must be overridden'

  #-----------------------------------------------------------------
  # Private property.  Do not change.
  isBatchCommand: bool = False

  #-----------------------------------------------------------------
  def __init__(self) -> None:
    '''Creates a new AxeCommandBase.
    '''

    pass

  #---------------------------------------------------------------
  # AxeCommandBase subclasses, must also have a 'run()' method,
  # but it's type is too complicated to have typed here.
  #
  # Your 'run' method may take any, all, or none of the following
  # arguments:
  #
  # def run(self,
  #         session: Session,
  #         config: Config,
  #         args: List[str],
  #         wantsTabCompletion: bool) -> None:
  #
  #   raise NotImplelmentedError()
