#-------------------------------------------------------------------
# aConf.py
#
# The ram.conf file.
#
# Copyright 2013  Applied Minds, Inc
#-------------------------------------------------------------------

"""The contents of the ram.conf file.
"""

#-------------------------------------------------------------------
# Import statements go here.
#
from typing import Dict
#
# Import statements go above this line.
#-------------------------------------------------------------------


#-------------------------------------------------------------------
# Default values.
#
# [key, defaultValue]
#
# If a key is not found in an installation, the key will be
# looked up in this dictionary, and if found, this value
# will be used for the installation.
#
# This is useful if you have the same value across all installs
# except one or two.  (If you have the same value in all installs
# with no exceptions, you should just hard-code it into the
# aConfTemplate string below).
#
defaultValues: Dict[str, str] = {
  'db.url':'postgresql+psycopg2://ramwebapp:ramwebapp@localhost:5432/ramwebapp',
  'auth.urls': 'TBD',
  'auth.users': '',
  'log.commanddir': '/var/ram/webapp/log/command',
  'log.webdir': '/var/ram/webapp/log/web',
}

#-------------------------------------------------------------------
aConfTemplate = r"""# RAM config file.

#------------------------------------------------------------------------
# Database configuration

# The URL to use to connect to the database.
#
db.url=${db.url}

# The number of connections allowed permanently in the connection pool.
#
db.poolSize=5

# The number of connections allowed temporarily above poolSize.
#
db.poolOverflow=20

# Number of seconds after which a connection will be killed.
#
# Setting to -1 means never.
#
db.poolRecycle=-1

# How long a request will wait for a connection before giving up.
#
db.poolTimeout=30

#------------------------------------------------------------------------
# Authentication configuration.

# The URL of the web service to use for authentication.
auth.urls=${auth.urls}

# A list of usernames and passwords that will be accepted.
#
# There is a colon between the user name and passsword.
# There is a comma between each user.
#
# For example to accept user1/pass1 and user2/pass2 as users:
#
#  auth.users=user1:pass1,user2:pass2
#
# If blank, any username/password will be accepted.
#
auth.users=${auth.users}

#------------------------------------------------------------------------
# Web server configuration.

# Session time out.
#
# If this many seconds passes with no server call by the user,
# the user will be logged out.
#
web.sessionTimeOut=3600

# The URL of the crop doctor web service.
web.findYieldEventUrl=https://cropdoctordemo.appliedinvention.com/app/yieldEvent/find

#------------------------------------------------------------------------
# Logging configuration.

# The directory that the web server should write log files to.
log.webdir=${log.webdir}

# The directory that command line tools should write log files to.
log.commanddir=${log.commanddir}

# Set to 'yes' if you want RAM debug messages written to the error log.
log.debug=no

# Set to 'yes' if you want all SQL statements to be written to the DB log.
log.sql=no
"""
