#-------------------------------------------------------------------
#  WebActionTs.py
#
#  The WebActionTs class.
#
#  Copyright 2014 Applied Invention, LLC.
#-------------------------------------------------------------------

'''The module containing the WebActionTs class.
'''

#-------------------------------------------------------------------
# Import statements go here.
#
from ai.axe.classJson import ClassJsonTypescriptWriter
from ai.axe.web.api.desc import WebDesc
from ai.axe.web.api.desc import WebDescTypescriptWriter
from ai.axe.web.app import AppSetup
import os
#
# Import statements go above this line.
#-------------------------------------------------------------------


#===================================================================
class WebActionTs:
  '''Generates a webapi Typescript stub file.
  '''

  fileHeader = '''\
//------------------------------------------------------------------
//  webActions.ts
//
// This file contains generated Typescript stub code to allow calls
// to web actions.
//
//------------------------------------------------------------------

// Allow this file to break the 80-char-max-line-length rule.
/* tslint:disable:max-line-length */

// Allow this file to declare members in constructor argument lists.
/* tslint:disable:no-parameter-properties */

import { Day } from '../axe/date/Day';
import { Duration } from '../axe/date/Duration';
import { ClassJsonRegistry } from '../axe/classJson/ClassJsonRegistry';
import { ClassJsonDesc } from '../axe/classJson/ClassJsonDesc';
import { JsonAny } from '../axe/classJson/jsonTypes/JsonAny';
import { JsonDate } from '../axe/classJson/jsonTypes/JsonDate';
import { JsonDateTime } from '../axe/classJson/jsonTypes/JsonDateTime';
import { JsonDuration } from '../axe/classJson/jsonTypes/JsonDuration';
import { JsonLink } from '../axe/classJson/jsonTypes/JsonLink';
import { JsonList } from '../axe/classJson/jsonTypes/JsonList';
import { JsonMap } from '../axe/classJson/jsonTypes/JsonMap';
import { JsonObj } from '../axe/classJson/jsonTypes/JsonObj';
import { JsonPrimitiveType } from '../axe/classJson/jsonTypes/JsonPrimitiveType';

import * as axeHttp from '../axe/util/http';
import { Observable } from 'rxjs';
import { Map } from '../axe/util/Map';
import { RequestParams } from '../axe/util/RequestParams';
import { Subscription } from 'rxjs';


'''

  #-----------------------------------------------------------------
  def __init__(self) -> None:
    '''Creates a new WebActionTs.
    '''

    pass

  #-----------------------------------------------------------------
  @staticmethod
  def generateWebActionTs() -> None:
    '''Generates a web action Typescript stub file.
    '''

    appSetup = AppSetup.get()

    homeDir = os.environ[appSetup.appNameAllCaps() + '_HOME']

    outDirName = homeDir + '/src/webapp/htmllib/gen'

    WebActionTs.generate(outDirName)

  #-----------------------------------------------------------------
  @staticmethod
  def generate(outDirName: str) -> None:
    '''Generates web action typescript stub files at the specified location.

    @param outDirName The name of the directory in which to write files.
    '''

    (interfaceText,
     classText) = ClassJsonTypescriptWriter().writeAll(WebDesc.allClasses(),
                                                       True)
    allVerbs = WebDesc.allVerbs(False)

    actionText = WebActionTs.fileHeader
    actionText += '\n'
    actionText += WebDescTypescriptWriter.formatVerbDict(allVerbs)

    texts = [(interfaceText, 'classJsonInterface.ts'),
             (classText, 'classJsonClass.ts'),
             (actionText, 'webActions.ts')]

    for text, fileName in texts:

      outFileName = os.path.join(outDirName, fileName)
      open(outFileName, 'w', encoding='utf-8').write(text)
