#-------------------------------------------------------------------
#  UploadDiamond.py
#
#  The UploadDiamond web action module.
#
#  Copyright 2016 Applied Invention, LLC
#-------------------------------------------------------------------

'''The UploadDiamond web action module.
'''

#-------------------------------------------------------------------
# Import statements go here.
#
from ai.axe.classJson import ClassJsonField
from ai.axe.web.api.desc import JsonResponseDesc
from ai.axe.web.api.desc import WebVerb
from ai.axe.web.api.desc import WebParam
from sqlalchemy.orm.session import Session
from typing import Any
from typing import Dict
from typing import List
from werkzeug.datastructures import FileStorage
#
# Import statements go above this line.
#-------------------------------------------------------------------


#-------------------------------------------------------------------
@WebVerb([WebParam('numDiamonds', int),
          WebParam('singleFile', FileStorage),
          WebParam('multiFiles', [FileStorage])],
          JsonResponseDesc([ClassJsonField('numFilesReceived', int)]))
def uploadDiamond(session: Session,
                  userInfo: Any,
                  numDiamonds: int,
                  singleFile: FileStorage,
                  multiFiles: List[FileStorage]) -> Dict[str, object]:
  '''Web action for testing:  Upload a diamond.

  @webParam numDiamonds The number of diamonds involved.
  @webParam singleFile A file to upload.
  @webParam mulitFiles Additional files to upload.
  '''

  # Supress unused variable warnings.
  # pylint: disable=self-assigning-variable
  session = session
  userInfo = userInfo
  numDiamonds = numDiamonds
  singleFile = singleFile
  multiFiles = multiFiles

  return {"numFilesReceived": 24}
