#-------------------------------------------------------------------
#  Seller.py
#
#  The Seller class.
#
#  Copyright 2016 Applied Invention, LLC
#-------------------------------------------------------------------

'''The module containing the Seller class.
'''

#-------------------------------------------------------------------
# Import statements go here.
#
from ai.axe.classJson import ClassJsonClass
from ai.axe.classJson import ClassJsonField
from ai.axe.util import StringUtil
from .Person import Person
#
# Import statements go above this line.
#-------------------------------------------------------------------


#===================================================================
@ClassJsonClass([ClassJsonField('name', str),
                 ClassJsonField('minPriceAccepted', int)])
class Seller(Person):
  '''(Test class) A person who buys diamonds.
  '''

  #-----------------------------------------------------------------
  def __init__(self, name: str, minPriceAccepted: int) -> None:
    '''Creates a new Seller.
    '''

    Person.__init__(self, name)

    self.minPriceAccepted: int = minPriceAccepted

  #----------------------------------------------------------------
  def __repr__(self) -> str:
    '''Returns a string representation of this object
    '''
    attrs = ['name', 'minPriceAccepted']

    return StringUtil.formatRepr(self, attrs)
