#-------------------------------------------------------------------
#  SellDiamond.py
#
#  The SellDiamond web action module.
#
#  Copyright 2016 Applied Invention, LLC
#-------------------------------------------------------------------

'''The SellDiamond web action module.
'''

#-------------------------------------------------------------------
# Import statements go here.
#
from .Diamond import Diamond
from ai.axe.classJson import ClassJsonField
from ai.axe.web.api.desc import JsonResponseDesc
from ai.axe.web.api.desc import WebVerb
from ai.axe.web.api.desc import WebParam
from sqlalchemy.orm.session import Session
from typing import Any
from typing import Dict
#
# Import statements go above this line.
#-------------------------------------------------------------------


#-------------------------------------------------------------------
@WebVerb([WebParam('diamond', Diamond)],
          JsonResponseDesc([ClassJsonField('change', int),
                            ClassJsonField('sellerName', str)]))
def sellDiamond(session: Session,
                userInfo: Any,
                diamond: Diamond) -> Dict[str, object]:
  '''Web action for testing:  Sell a diamond.

  @webParam diamond The diamond to sell.
  '''

  # Supress unused variable warnings.
  # pylint: disable=self-assigning-variable
  session = session
  userInfo = userInfo
  diamond = diamond

  return {"change": 24,
          "sellerName": "Mark"}
