#-------------------------------------------------------------------
#  Person.py
#
#  The Person class.
#
#  Copyright 2016 Applied Invention, LLC
#-------------------------------------------------------------------

'''The module containing the Person class.
'''

#-------------------------------------------------------------------
# Import statements go here.
#
from ai.axe.classJson import ClassJsonClass
from ai.axe.classJson import ClassJsonField
from ai.axe.util import StringUtil
#
# Import statements go above this line.
#-------------------------------------------------------------------


#===================================================================
@ClassJsonClass([ClassJsonField('name', str)], isAbstract=True)
class Person:
  '''(Test class) A person involved in trading diamonds.
  '''

  #-----------------------------------------------------------------
  def __init__(self, name: str) -> None:
    '''Creates a new Person.
    '''

    self.name: str = name

  #----------------------------------------------------------------
  def __repr__(self) -> str:
    '''Returns a string representation of this object
    '''
    attrs = ['name']

    return StringUtil.formatRepr(self, attrs)
