#-------------------------------------------------------------------
#  FindPersonDiamond.py
#
#  The FindPersonDiamond web action module.
#
#  Copyright 2016 Applied Invention, LLC
#-------------------------------------------------------------------

'''The FindPersonDiamond web action module.
'''

#-------------------------------------------------------------------
# Import statements go here.
#
from .Person import Person
from ai.axe.classJson import ClassJsonField
from ai.axe.web.api.desc import JsonResponseDesc
from ai.axe.web.api.desc import WebVerb
from ai.axe.web.api.desc import WebParam
from sqlalchemy.orm.session import Session
from typing import Any
from typing import Dict
#
# Import statements go above this line.
#-------------------------------------------------------------------


#-------------------------------------------------------------------
@WebVerb([WebParam('personName', str)],
          JsonResponseDesc([ClassJsonField('person', Person)]))
def findPersonDiamond(session: Session,
                      userInfo: Any,
                      personName: str) -> Dict[str, object]:
  '''Web action for testing:  Find a person

  @webParam personName The name of the person to find.
  '''

  # Supress unused variable warnings.
  # pylint: disable=self-assigning-variable
  session = session
  userInfo = userInfo
  personName = personName

  return {"person": None}

#-------------------------------------------------------------------
@WebVerb([WebParam('person', Person)],
          JsonResponseDesc([ClassJsonField('exists', bool)]),
         flavor="exists")
def findPersonDiamondExists(session: Session,
                            userInfo: Any,
                            person: Person) -> Dict[str, object]:
  '''Web action for testing:  Find a person

  @webParam personName The name of the person to find.
  '''

  # Supress unused variable warnings.
  # pylint: disable=self-assigning-variable
  session = session
  userInfo = userInfo
  person = person

  return {"exists": False}
