#-------------------------------------------------------------------
#  FindBuyerDiamond.py
#
#  The FindBuyerDiamond web action module.
#
#  Copyright 2016 Applied Invention, LLC
#-------------------------------------------------------------------

'''The FindBuyerDiamond web action module.
'''

#-------------------------------------------------------------------
# Import statements go here.
#
from .Seller import Seller
from .Buyer import Buyer
from ai.axe.classJson import ClassJsonField
from ai.axe.web.api.desc import JsonResponseDesc
from ai.axe.web.api.desc import WebVerb
from ai.axe.web.api.desc import WebParam
from sqlalchemy.orm.session import Session
from typing import Any
from typing import Dict
#
# Import statements go above this line.
#-------------------------------------------------------------------


#-------------------------------------------------------------------
@WebVerb([WebParam('seller', Seller)],
          JsonResponseDesc([ClassJsonField('buyer', Buyer)]))
def findBuyerDiamond(session: Session,
                     userInfo: Any,
                     seller: Seller) -> Dict[str, object]:
  '''Web action for testing:  Find a buyer.

  @webParam seller The seller to find a buyer for.
  '''

  # Supress unused variable warnings.
  # pylint: disable=self-assigning-variable
  session = session
  userInfo = userInfo
  seller = seller

  return {"buyer": None}
