#-------------------------------------------------------------------
#  Diamond.py
#
#  The Diamond class.
#
#  Copyright 2016 Applied Invention, LLC
#-------------------------------------------------------------------

'''The module containing the Diamond class.
'''

#-------------------------------------------------------------------
# Import statements go here.
#
from ai.axe.classJson import ClassJsonClass
from ai.axe.classJson import ClassJsonField
from ai.axe.util import StringUtil
#
# Import statements go above this line.
#-------------------------------------------------------------------


#===================================================================
@ClassJsonClass([ClassJsonField('name', str),
                 ClassJsonField('weight', float),
                 ClassJsonField('numFaces', int)])
class Diamond:
  '''A test class Diamond.
  '''

  #-----------------------------------------------------------------
  def __init__(self, name: str, weight: float, numFaces: int) -> None:
    '''Creates a new Diamond.
    '''

    self.name: str = name
    self.weight: float = weight
    self.numFaces: int = numFaces

  #----------------------------------------------------------------
  def __repr__(self) -> str:
    '''Returns a string representation of this object
    '''
    attrs = ['name', 'weight', 'numFaces']

    return StringUtil.formatRepr(self, attrs)
