#-------------------------------------------------------------------
#  Buyer.py
#
#  The Buyer class.
#
#  Copyright 2016 Applied Invention, LLC
#-------------------------------------------------------------------

'''The module containing the Buyer class.
'''

#-------------------------------------------------------------------
# Import statements go here.
#
from ai.axe.classJson import ClassJsonClass
from ai.axe.classJson import ClassJsonField
from ai.axe.util import StringUtil
from .Person import Person
#
# Import statements go above this line.
#-------------------------------------------------------------------


#===================================================================
@ClassJsonClass([ClassJsonField('name', str),
                 ClassJsonField('maxBid', int)])
class Buyer(Person):
  '''(Test class) A person who buys diamonds.
  '''

  #-----------------------------------------------------------------
  def __init__(self, name: str, maxBid: int) -> None:
    '''Creates a new Buyer.
    '''

    Person.__init__(self, name)

    self.maxBid: int = maxBid

  #----------------------------------------------------------------
  def __repr__(self) -> str:
    '''Returns a string representation of this object
    '''
    attrs = ['name', 'maxBid']

    return StringUtil.formatRepr(self, attrs)
