#-------------------------------------------------------------------
#  BuyDiamond.py
#
#  The BuyDiamond web action module.
#
#  Copyright 2016 Applied Invention, LLC
#-------------------------------------------------------------------

'''The BuyDiamond web action module.
'''

#-------------------------------------------------------------------
# Import statements go here.
#
from .Diamond import Diamond
from datetime import date
from datetime import datetime
from ai.axe.web.api.desc import WebVerb
from ai.axe.web.api.desc import WebParam
from typing import List
#
# Import statements go above this line.
#-------------------------------------------------------------------


#-------------------------------------------------------------------
@WebVerb([WebParam('weight', float),
          WebParam('minedOn', date),
          WebParam('deadline', datetime),
          WebParam('preferredName', str),
          WebParam('preferredCountries', [str])],
         Diamond)
def buyDiamond(weight: float,
               minedOn: date,
               deadline: datetime,
               preferredName: str,
               preferredCountries: List[str]) -> Diamond:
  '''Web action for testing:  Buy a diamond.

  @webParam weight The desired weight.
  @webParam minedOn The desired date the diamond was mined.
  @webParam deadline The sale must be made by this time.
  @webParam preferredName The desired name.
  @webParam preferredCountries A list of acceptable countries.
  '''

  # Suppress unused variable warnings.
  # pylint: disable=self-assigning-variable
  weight = weight
  minedOn = minedOn
  deadline = deadline
  preferredName = preferredName
  preferredCountries = preferredCountries

  return Diamond("My Diamond", 22.1, 18)
