#-------------------------------------------------------------------
#  AppraiseDiamond.py
#
#  The AppraiseDiamond web action module.
#
#  Copyright 2016 Applied Invention, LLC
#-------------------------------------------------------------------

'''The AppraiseDiamond web action module.
'''

#-------------------------------------------------------------------
# Import statements go here.
#
from .Diamond import Diamond
from ai.axe.classJson import ClassJsonField
from ai.axe.web.api import BinaryResponse
from ai.axe.web.api import DownloadResponse
from ai.axe.web.api.desc import JsonResponseDesc
from ai.axe.web.api.desc import WebVerb
from ai.axe.web.api.desc import WebParam
from sqlalchemy.orm.session import Session
from typing import Any
from typing import Dict
from typing import List
from werkzeug.wrappers import Response
#
# Import statements go above this line.
#-------------------------------------------------------------------

# pylint: disable=R1711

#-------------------------------------------------------------------
@WebVerb([WebParam('diamond', Diamond)],
          JsonResponseDesc([ClassJsonField('value', int),
                            ClassJsonField('quality', str)]))
def appraiseDiamond(session: Session,
                    userInfo: Any,
                    diamond: Diamond) -> Dict[str, object]:
  '''Web action for testing:  Appraise a diamond.

  @webParam diamond The diamond to appraise.
  '''

  # Supress unused variable warnings.
  # pylint: disable=self-assigning-variable
  session = session
  userInfo = userInfo
  diamond = diamond

  return {"value": 123,
          "quality": 'good'}

#-------------------------------------------------------------------
@WebVerb([WebParam('diamonds', [Diamond])],
          JsonResponseDesc([ClassJsonField('values', [int])]),
         'multiple')
def appraiseDiamondMultiple(session: Session,
                            userInfo: Any,
                            diamonds: List[Diamond]) -> Dict[str, object]:
  '''Web action for testing:  Appraise multiple diamonds.

  @webParam diamonds The diamonds to appraise.
  '''

  # Supress unused variable warnings.
  # pylint: disable=self-assigning-variable
  session = session
  userInfo = userInfo
  diamonds = diamonds

  # pylint: disable=W0612
  return {"values": [123 for diamond in diamonds]}

#-------------------------------------------------------------------
@WebVerb([WebParam('diamond', Diamond)],
         DownloadResponse,
         'pdf')
def appraiseDiamondPdf(session: Session,
                       userInfo: Any,
                       diamond: Diamond) -> Any:
  '''Web action for testing:  Appraise a diamond and download a PDF.

  @webParam diamond The diamond to appraise.
  '''

  # Supress unused variable warnings.
  # pylint: disable=self-assigning-variable
  session = session
  userInfo = userInfo
  diamond = diamond

  return None

#-------------------------------------------------------------------
@WebVerb([WebParam('diamond', Diamond)],
         BinaryResponse,
         'image')
def appraiseDiamondImage(session: Session,
                         userInfo: Any,
                         diamond: Diamond) -> Any:
  '''Web action for testing:  Appraise a diamond and download an image.

  @webParam diamond The diamond to appraise.
  '''

  # Supress unused variable warnings.
  # pylint: disable=self-assigning-variable
  session = session
  userInfo = userInfo
  diamond = diamond

  return None

#-------------------------------------------------------------------
@WebVerb([WebParam('diamond', Diamond)],
         str,
         'text')
def appraiseDiamondText(session: Session,
                        userInfo: Any,
                        diamond: Diamond) -> Any:
  '''Web action for testing:  Appraise a diamond and download some text.

  @webParam diamond The diamond to appraise.
  '''

  # Supress unused variable warnings.
  # pylint: disable=self-assigning-variable
  session = session
  userInfo = userInfo
  diamond = diamond

  return None

#-------------------------------------------------------------------
@WebVerb([WebParam('diamond', Diamond)],
         Response,
         'rawResponse')
def appraiseDiamondRaw(session: Session,
                       userInfo: Any,
                       diamond: Diamond) -> Any:
  '''Web action for testing:  Appraise a diamond and download a raw response.

  @webParam diamond The diamond to appraise.
  '''

  # Supress unused variable warnings.
  # pylint: disable=self-assigning-variable
  session = session
  userInfo = userInfo
  diamond = diamond

  return None

#-------------------------------------------------------------------
@WebVerb([WebParam('diamond', Diamond)],
         None,
         'noResponse')
def appraiseDiamondNoResponse(session: Session,
                              userInfo: Any,
                              diamond: Diamond) -> None:
  '''Web action for testing:  Appraise a diamond and get no response.

  @webParam diamond The diamond to appraise.
  '''

  # Supress unused variable warnings.
  # pylint: disable=self-assigning-variable
  session = session
  userInfo = userInfo
  diamond = diamond

  return None

#-------------------------------------------------------------------
@WebVerb([WebParam('diamonds', [Diamond])],
          JsonResponseDesc([ClassJsonField('values', [int])]),
         'internalFalse',
         internal=False)
def appraiseDiamondInternalFalse(session: Session,
                                 userInfo: Any,
                                 diamonds: List[Diamond]) -> Dict[str, object]:
  '''Web action for testing:  Appraise multiple diamonds.

  @webParam diamonds The diamonds to appraise.
  '''

  # Supress unused variable warnings.
  # pylint: disable=self-assigning-variable
  session = session
  userInfo = userInfo
  diamonds = diamonds

  # pylint: disable=W0612
  return {"values": [123 for diamond in diamonds]}
