#-------------------------------------------------------------------
#  TestWebDescTypescriptWriterStrings.py
#
#  The TestWebDescTypescriptWriterStrings module.
#
#  Copyright 2016 Applied Invention, LLC
#-------------------------------------------------------------------

''' Strings used in the TestWebDescTypescriptWriter unit test.
'''

#===================================================================

class WebDescTypescriptWriterStrings:

  #-----------------------------------------------------------------
  def __init__(self) -> None:
    ''' Creates a new TestWebDescTypescriptWriterStrings
        Initializes the member variables representing test strings.
    '''

    # The expected Typescript text for AppraiseDiamondMultiple.
    self.appraiseDiamondMultipleDescText: str = '''\

import { Diamond } from './classJsonInterface';

export type ErrorHandler = (response?: any) => void;

export type AppraiseDiamondMultipleSuccessHandler =
  (response: AppraiseDiamondMultipleResponse) => void;

export interface AppraiseDiamondMultipleResponse
{
  values: Array<number>;
}

export function appraiseDiamondMultiple(diamonds: Array<Diamond>,
                                        successHandler?: AppraiseDiamondMultipleSuccessHandler,
                                        errorHandler?: ErrorHandler) : [Observable<any>, Subscription]
{
  let params: RequestParams = new RequestParams();

  params.add("diamonds", diamonds);

  let actionUrl = '/app/diamond/appraise/multiple';

  let observable: Observable<any> = axeHttp.createRequest(actionUrl, params);
  let subscription: Subscription = null;

  if (successHandler)
  {
    if (!errorHandler)
    {
      errorHandler = axeHttp.defaultOnError;
    }

    subscription = observable.subscribe(successHandler,
                                        errorHandler);
  }

  return [observable, subscription];
}




// The types below are private implementation classes.
// Do not use them.
// You should instead use the interfaces listed above.

class BasicAppraiseDiamondMultipleResponse
{
  constructor(public values: Array<number>)
  {
  }

  static fromJson(src: AppraiseDiamondMultipleResponse) : BasicAppraiseDiamondMultipleResponse
  {
    return new BasicAppraiseDiamondMultipleResponse(src.values);
  }

  static toJson(src: BasicAppraiseDiamondMultipleResponse) : AppraiseDiamondMultipleResponse
  {
    return src;
  }
}



export function registerDefaults() : void
{
  ClassJsonRegistry.registry.register('AppraiseDiamondMultipleResponse',
                                      BasicAppraiseDiamondMultipleResponse,
                                      false);
}

export function registerDescs() : void
{
  let desc: ClassJsonDesc = null;

  desc = new ClassJsonDesc("AppraiseDiamondMultipleResponse");
  desc.addField("values", new JsonList(new JsonPrimitiveType("int")));
  ClassJsonRegistry.registry.addDesc(desc);
}
'''

    # The expected Typescript text for AppraiseDiamondText.
    self.appraiseDiamondTextDescText = '''\

import { Diamond } from './classJsonInterface';

export type ErrorHandler = (response?: any) => void;

export type AppraiseDiamondTextSuccessHandler =
  (response: string) => void;

export function appraiseDiamondText(diamond: Diamond,
                                    successHandler?: AppraiseDiamondTextSuccessHandler,
                                    errorHandler?: ErrorHandler) : [Observable<any>, Subscription]
{
  let params: RequestParams = new RequestParams();

  params.add("diamond", diamond);

  let actionUrl = '/app/diamond/appraise/text';

  let observable: Observable<any> = axeHttp.createRequest(actionUrl, params);
  let subscription: Subscription = null;

  if (successHandler)
  {
    if (!errorHandler)
    {
      errorHandler = axeHttp.defaultOnError;
    }

    subscription = observable.subscribe(successHandler,
                                        errorHandler);
  }

  return [observable, subscription];
}




// The types below are private implementation classes.
// Do not use them.
// You should instead use the interfaces listed above.


export function registerDefaults() : void
{
}

export function registerDescs() : void
{
  let desc: ClassJsonDesc = null;
}
'''

    # The expected Typescript text for AppraiseDiamondImage.
    self.appraiseDiamondImageDescText = '''\

import { Diamond } from './classJsonInterface';

export type ErrorHandler = (response?: any) => void;

export function appraiseDiamondImage(diamond: Diamond) : [Observable<any>, Subscription]
{
  let params: RequestParams = new RequestParams();

  params.add("diamond", diamond);

  let actionUrl = '/app/diamond/appraise/image';

  let observable: Observable<any> = axeHttp.createRequest(actionUrl, params);
  let subscription: Subscription = null;

  subscription = observable.subscribe();


  return [observable, subscription];
}




// The types below are private implementation classes.
// Do not use them.
// You should instead use the interfaces listed above.


export function registerDefaults() : void
{
}

export function registerDescs() : void
{
  let desc: ClassJsonDesc = null;
}
'''

    # The expected Typescript text for AppraiseDiamondPdf.
    self.appraiseDiamondPdfDescText = '''\

import { Diamond } from './classJsonInterface';

export type ErrorHandler = (response?: any) => void;

export function appraiseDiamondPdf(diamond: Diamond) : [Observable<any>, Subscription]
{
  let params: RequestParams = new RequestParams();

  params.add("diamond", diamond);

  let actionUrl = '/app/diamond/appraise/pdf';

  let observable: Observable<any> = axeHttp.createRequest(actionUrl, params);
  let subscription: Subscription = null;

  subscription = observable.subscribe();


  return [observable, subscription];
}




// The types below are private implementation classes.
// Do not use them.
// You should instead use the interfaces listed above.


export function registerDefaults() : void
{
}

export function registerDescs() : void
{
  let desc: ClassJsonDesc = null;
}
'''

    # The expected Typescript text for AppraiseDiamondRaw.
    self.appraiseDiamondRawDescText = '''\

import { Diamond } from './classJsonInterface';

export type ErrorHandler = (response?: any) => void;

export function appraiseDiamondRawResponse(diamond: Diamond) : [Observable<any>, Subscription]
{
  let params: RequestParams = new RequestParams();

  params.add("diamond", diamond);

  let actionUrl = '/app/diamond/appraise/rawResponse';

  let observable: Observable<any> = axeHttp.createRequest(actionUrl, params);
  let subscription: Subscription = null;

  subscription = observable.subscribe();


  return [observable, subscription];
}




// The types below are private implementation classes.
// Do not use them.
// You should instead use the interfaces listed above.


export function registerDefaults() : void
{
}

export function registerDescs() : void
{
  let desc: ClassJsonDesc = null;
}
'''

    # The expected Typescript text for listDiamond
    self.listDiamondDescText = '''\



export type ErrorHandler = (response?: any) => void;

export type ListDiamondSuccessHandler =
  (response: ListDiamondResponse) => void;

export interface ListDiamondResponse
{
  names: Array<string>;
}

export function listDiamond(successHandler?: ListDiamondSuccessHandler,
                            errorHandler?: ErrorHandler) : [Observable<any>, Subscription]
{
  let params: RequestParams = new RequestParams();

  let actionUrl = '/app/diamond/list';

  let observable: Observable<any> = axeHttp.createRequest(actionUrl, params);
  let subscription: Subscription = null;

  if (successHandler)
  {
    if (!errorHandler)
    {
      errorHandler = axeHttp.defaultOnError;
    }

    subscription = observable.subscribe(successHandler,
                                        errorHandler);
  }

  return [observable, subscription];
}




// The types below are private implementation classes.
// Do not use them.
// You should instead use the interfaces listed above.

class BasicListDiamondResponse
{
  constructor(public names: Array<string>)
  {
  }

  static fromJson(src: ListDiamondResponse) : BasicListDiamondResponse
  {
    return new BasicListDiamondResponse(src.names);
  }

  static toJson(src: BasicListDiamondResponse) : ListDiamondResponse
  {
    return src;
  }
}



export function registerDefaults() : void
{
  ClassJsonRegistry.registry.register('ListDiamondResponse',
                                      BasicListDiamondResponse,
                                      false);
}

export function registerDescs() : void
{
  let desc: ClassJsonDesc = null;

  desc = new ClassJsonDesc("ListDiamondResponse");
  desc.addField("names", new JsonList(new JsonPrimitiveType("string")));
  ClassJsonRegistry.registry.addDesc(desc);
}
'''

    # The expected Typescript text for sellDiamond
    self.sellDiamondDescText = '''\

import { Diamond } from './classJsonInterface';

export type ErrorHandler = (response?: any) => void;

export type SellDiamondSuccessHandler =
  (response: SellDiamondResponse) => void;

export interface SellDiamondResponse
{
  change: number;
  sellerName: string;
}

export function sellDiamond(diamond: Diamond,
                            successHandler?: SellDiamondSuccessHandler,
                            errorHandler?: ErrorHandler) : [Observable<any>, Subscription]
{
  let params: RequestParams = new RequestParams();

  params.add("diamond", diamond);

  let actionUrl = '/app/diamond/sell';

  let observable: Observable<any> = axeHttp.createRequest(actionUrl, params);
  let subscription: Subscription = null;

  if (successHandler)
  {
    if (!errorHandler)
    {
      errorHandler = axeHttp.defaultOnError;
    }

    subscription = observable.subscribe(successHandler,
                                        errorHandler);
  }

  return [observable, subscription];
}




// The types below are private implementation classes.
// Do not use them.
// You should instead use the interfaces listed above.

class BasicSellDiamondResponse
{
  constructor(public change: number,
              public sellerName: string)
  {
  }

  static fromJson(src: SellDiamondResponse) : BasicSellDiamondResponse
  {
    return new BasicSellDiamondResponse(src.change,
                                        src.sellerName);
  }

  static toJson(src: BasicSellDiamondResponse) : SellDiamondResponse
  {
    return src;
  }
}



export function registerDefaults() : void
{
  ClassJsonRegistry.registry.register('SellDiamondResponse',
                                      BasicSellDiamondResponse,
                                      false);
}

export function registerDescs() : void
{
  let desc: ClassJsonDesc = null;

  desc = new ClassJsonDesc("SellDiamondResponse");
  desc.addField("change", new JsonPrimitiveType("int"));
  desc.addField("sellerName", new JsonPrimitiveType("string"));
  ClassJsonRegistry.registry.addDesc(desc);
}
'''

    # The expected Typescript text for buyDiamond.
    self.buyDiamondDescText = '''\

import { Diamond } from './classJsonInterface';

export type ErrorHandler = (response?: any) => void;

export type BuyDiamondSuccessHandler =
  (response: Diamond) => void;

export function buyDiamond(weight: number,
                           minedOn: Day,
                           deadline: Date,
                           preferredName: string,
                           preferredCountries: Array<string>,
                           successHandler?: BuyDiamondSuccessHandler,
                           errorHandler?: ErrorHandler) : [Observable<any>, Subscription]
{
  let params: RequestParams = new RequestParams();

  params.add("weight", weight);
  params.add("minedOn", minedOn);
  params.add("deadline", deadline);
  params.add("preferredName", preferredName);
  params.add("preferredCountries", preferredCountries);

  let actionUrl = '/app/diamond/buy';

  let observable: Observable<any> = axeHttp.createRequest(actionUrl, params);
  let subscription: Subscription = null;

  if (successHandler)
  {
    if (!errorHandler)
    {
      errorHandler = axeHttp.defaultOnError;
    }

    subscription = observable.subscribe(successHandler,
                                        errorHandler);
  }

  return [observable, subscription];
}




// The types below are private implementation classes.
// Do not use them.
// You should instead use the interfaces listed above.


export function registerDefaults() : void
{
}

export function registerDescs() : void
{
  let desc: ClassJsonDesc = null;

  desc = new ClassJsonDesc("Diamond");
  desc.addField("name", new JsonPrimitiveType("string"));
  desc.addField("weight", new JsonPrimitiveType("float"));
  desc.addField("numFaces", new JsonPrimitiveType("int"));
  ClassJsonRegistry.registry.addDesc(desc);
}
'''

    # The expected Typescript text for uploadDiamond
    self.uploadDiamond = '''\



export type ErrorHandler = (response?: any) => void;

export type UploadDiamondSuccessHandler =
  (response: UploadDiamondResponse) => void;

export interface UploadDiamondResponse
{
  numFilesReceived: number;
}

export function uploadDiamond(numDiamonds: number,
                              singleFile: File,
                              multiFiles: FileList,
                              successHandler?: UploadDiamondSuccessHandler,
                              errorHandler?: ErrorHandler) : [Observable<any>, Subscription]
{
  let params: RequestParams = new RequestParams();

  params.add("numDiamonds", numDiamonds);

  let formData = new FormData();

  formData.append("singleFile", singleFile);
  axeHttp.appendFileList(formData, "multiFiles", multiFiles);

  let actionUrl = '/app/diamond/upload';

  let observable: Observable<any> = axeHttp.createRequest(actionUrl, params, "POST", formData);
  let subscription: Subscription = null;

  if (successHandler)
  {
    if (!errorHandler)
    {
      errorHandler = axeHttp.defaultOnError;
    }

    subscription = observable.subscribe(successHandler,
                                        errorHandler);
  }

  return [observable, subscription];
}




// The types below are private implementation classes.
// Do not use them.
// You should instead use the interfaces listed above.

class BasicUploadDiamondResponse
{
  constructor(public numFilesReceived: number)
  {
  }

  static fromJson(src: UploadDiamondResponse) : BasicUploadDiamondResponse
  {
    return new BasicUploadDiamondResponse(src.numFilesReceived);
  }

  static toJson(src: BasicUploadDiamondResponse) : UploadDiamondResponse
  {
    return src;
  }
}



export function registerDefaults() : void
{
  ClassJsonRegistry.registry.register('UploadDiamondResponse',
                                      BasicUploadDiamondResponse,
                                      false);
}

export function registerDescs() : void
{
  let desc: ClassJsonDesc = null;

  desc = new ClassJsonDesc("UploadDiamondResponse");
  desc.addField("numFilesReceived", new JsonPrimitiveType("int"));
  ClassJsonRegistry.registry.addDesc(desc);
}
'''

    # The expected Typescript text for findBuyerDiamond
    self.findBuyerDiamond = '''\

import { Buyer } from './classJsonInterface';
import { Seller } from './classJsonInterface';

export type ErrorHandler = (response?: any) => void;

export type FindBuyerDiamondSuccessHandler =
  (response: FindBuyerDiamondResponse) => void;

export interface FindBuyerDiamondResponse
{
  buyer: Buyer;
}

export function findBuyerDiamond(seller: Seller,
                                 successHandler?: FindBuyerDiamondSuccessHandler,
                                 errorHandler?: ErrorHandler) : [Observable<any>, Subscription]
{
  let params: RequestParams = new RequestParams();

  params.add("seller", seller);

  let actionUrl = '/app/diamond/findBuyer';

  let observable: Observable<any> = axeHttp.createRequest(actionUrl, params);
  let subscription: Subscription = null;

  if (successHandler)
  {
    if (!errorHandler)
    {
      errorHandler = axeHttp.defaultOnError;
    }

    subscription = observable.subscribe(successHandler,
                                        errorHandler);
  }

  return [observable, subscription];
}




// The types below are private implementation classes.
// Do not use them.
// You should instead use the interfaces listed above.

class BasicFindBuyerDiamondResponse
{
  constructor(public buyer: Buyer)
  {
  }

  static fromJson(src: FindBuyerDiamondResponse) : BasicFindBuyerDiamondResponse
  {
    return new BasicFindBuyerDiamondResponse(src.buyer);
  }

  static toJson(src: BasicFindBuyerDiamondResponse) : FindBuyerDiamondResponse
  {
    return src;
  }
}



export function registerDefaults() : void
{
  ClassJsonRegistry.registry.register('FindBuyerDiamondResponse',
                                      BasicFindBuyerDiamondResponse,
                                      false);
}

export function registerDescs() : void
{
  let desc: ClassJsonDesc = null;

  desc = new ClassJsonDesc("FindBuyerDiamondResponse");
  desc.addField("buyer", new JsonObj("Buyer"));
  ClassJsonRegistry.registry.addDesc(desc);
}
'''

    # The expected Typescript text for findPersonDiamond
    self.findPersonDiamond = '''\

import { Buyer } from './classJsonInterface';
import { Person } from './classJsonInterface';
import { Seller } from './classJsonInterface';

export type ErrorHandler = (response?: any) => void;

export type FindPersonDiamondSuccessHandler =
  (response: FindPersonDiamondResponse) => void;

export interface FindPersonDiamondResponse
{
  person: Seller | Buyer;
}

export function findPersonDiamond(personName: string,
                                  successHandler?: FindPersonDiamondSuccessHandler,
                                  errorHandler?: ErrorHandler) : [Observable<any>, Subscription]
{
  let params: RequestParams = new RequestParams();

  params.add("personName", personName);

  let actionUrl = '/app/diamond/findPerson';

  let observable: Observable<any> = axeHttp.createRequest(actionUrl, params);
  let subscription: Subscription = null;

  if (successHandler)
  {
    if (!errorHandler)
    {
      errorHandler = axeHttp.defaultOnError;
    }

    subscription = observable.subscribe(successHandler,
                                        errorHandler);
  }

  return [observable, subscription];
}




// The types below are private implementation classes.
// Do not use them.
// You should instead use the interfaces listed above.

class BasicFindPersonDiamondResponse
{
  constructor(public person: Seller | Buyer)
  {
  }

  static fromJson(src: FindPersonDiamondResponse) : BasicFindPersonDiamondResponse
  {
    return new BasicFindPersonDiamondResponse(src.person);
  }

  static toJson(src: BasicFindPersonDiamondResponse) : FindPersonDiamondResponse
  {
    return src;
  }
}



export function registerDefaults() : void
{
  ClassJsonRegistry.registry.register('FindPersonDiamondResponse',
                                      BasicFindPersonDiamondResponse,
                                      false);
}

export function registerDescs() : void
{
  let desc: ClassJsonDesc = null;

  desc = new ClassJsonDesc("FindPersonDiamondResponse");
  desc.addField("person", new JsonObj("Person"));
  ClassJsonRegistry.registry.addDesc(desc);
}
'''

    # The expected Typescript text for findPersonExistsDiamond.
    self.findPersonExistsDiamond = '''\

import { Buyer } from './classJsonInterface';
import { Person } from './classJsonInterface';
import { Seller } from './classJsonInterface';

export type ErrorHandler = (response?: any) => void;

export type FindPersonDiamondExistsSuccessHandler =
  (response: FindPersonDiamondExistsResponse) => void;

export interface FindPersonDiamondExistsResponse
{
  exists: boolean;
}

export function findPersonDiamondExists(person: Seller | Buyer,
                                        successHandler?: FindPersonDiamondExistsSuccessHandler,
                                        errorHandler?: ErrorHandler) : [Observable<any>, Subscription]
{
  let params: RequestParams = new RequestParams();

  params.add("person", person);

  let actionUrl = '/app/diamond/findPerson/exists';

  let observable: Observable<any> = axeHttp.createRequest(actionUrl, params);
  let subscription: Subscription = null;

  if (successHandler)
  {
    if (!errorHandler)
    {
      errorHandler = axeHttp.defaultOnError;
    }

    subscription = observable.subscribe(successHandler,
                                        errorHandler);
  }

  return [observable, subscription];
}




// The types below are private implementation classes.
// Do not use them.
// You should instead use the interfaces listed above.

class BasicFindPersonDiamondExistsResponse
{
  constructor(public exists: boolean)
  {
  }

  static fromJson(src: FindPersonDiamondExistsResponse) : BasicFindPersonDiamondExistsResponse
  {
    return new BasicFindPersonDiamondExistsResponse(src.exists);
  }

  static toJson(src: BasicFindPersonDiamondExistsResponse) : FindPersonDiamondExistsResponse
  {
    return src;
  }
}



export function registerDefaults() : void
{
  ClassJsonRegistry.registry.register('FindPersonDiamondExistsResponse',
                                      BasicFindPersonDiamondExistsResponse,
                                      false);
}

export function registerDescs() : void
{
  let desc: ClassJsonDesc = null;

  desc = new ClassJsonDesc("FindPersonDiamondExistsResponse");
  desc.addField("exists", new JsonPrimitiveType("bool"));
  ClassJsonRegistry.registry.addDesc(desc);
}
'''

    # The expected Typescript text for all diamond webVerbs.
    self.allDescText = '''\

import { Buyer } from './classJsonInterface';
import { Diamond } from './classJsonInterface';
import { Person } from './classJsonInterface';
import { Seller } from './classJsonInterface';

export type ErrorHandler = (response?: any) => void;

export type AppraiseDiamondSuccessHandler =
  (response: AppraiseDiamondResponse) => void;

export interface AppraiseDiamondResponse
{
  value: number;
  quality: string;
}

export function appraiseDiamond(diamond: Diamond,
                                successHandler?: AppraiseDiamondSuccessHandler,
                                errorHandler?: ErrorHandler) : [Observable<any>, Subscription]
{
  let params: RequestParams = new RequestParams();

  params.add("diamond", diamond);

  let actionUrl = '/app/diamond/appraise';

  let observable: Observable<any> = axeHttp.createRequest(actionUrl, params);
  let subscription: Subscription = null;

  if (successHandler)
  {
    if (!errorHandler)
    {
      errorHandler = axeHttp.defaultOnError;
    }

    subscription = observable.subscribe(successHandler,
                                        errorHandler);
  }

  return [observable, subscription];
}

export function appraiseDiamondImage(diamond: Diamond) : [Observable<any>, Subscription]
{
  let params: RequestParams = new RequestParams();

  params.add("diamond", diamond);

  let actionUrl = '/app/diamond/appraise/image';

  let observable: Observable<any> = axeHttp.createRequest(actionUrl, params);
  let subscription: Subscription = null;

  subscription = observable.subscribe();


  return [observable, subscription];
}

export type AppraiseDiamondMultipleSuccessHandler =
  (response: AppraiseDiamondMultipleResponse) => void;

export interface AppraiseDiamondMultipleResponse
{
  values: Array<number>;
}

export function appraiseDiamondMultiple(diamonds: Array<Diamond>,
                                        successHandler?: AppraiseDiamondMultipleSuccessHandler,
                                        errorHandler?: ErrorHandler) : [Observable<any>, Subscription]
{
  let params: RequestParams = new RequestParams();

  params.add("diamonds", diamonds);

  let actionUrl = '/app/diamond/appraise/multiple';

  let observable: Observable<any> = axeHttp.createRequest(actionUrl, params);
  let subscription: Subscription = null;

  if (successHandler)
  {
    if (!errorHandler)
    {
      errorHandler = axeHttp.defaultOnError;
    }

    subscription = observable.subscribe(successHandler,
                                        errorHandler);
  }

  return [observable, subscription];
}

export type AppraiseDiamondNoResponseSuccessHandler =
  () => void;

export function appraiseDiamondNoResponse(diamond: Diamond,
                                          successHandler?: AppraiseDiamondNoResponseSuccessHandler,
                                          errorHandler?: ErrorHandler) : [Observable<any>, Subscription]
{
  let params: RequestParams = new RequestParams();

  params.add("diamond", diamond);

  let actionUrl = '/app/diamond/appraise/noResponse';

  let observable: Observable<any> = axeHttp.createRequest(actionUrl, params);
  let subscription: Subscription = null;

  if (successHandler)
  {
    if (!errorHandler)
    {
      errorHandler = axeHttp.defaultOnError;
    }

    subscription = observable.subscribe(successHandler,
                                        errorHandler);
  }

  return [observable, subscription];
}

export function appraiseDiamondPdf(diamond: Diamond) : [Observable<any>, Subscription]
{
  let params: RequestParams = new RequestParams();

  params.add("diamond", diamond);

  let actionUrl = '/app/diamond/appraise/pdf';

  let observable: Observable<any> = axeHttp.createRequest(actionUrl, params);
  let subscription: Subscription = null;

  subscription = observable.subscribe();


  return [observable, subscription];
}

export function appraiseDiamondRawResponse(diamond: Diamond) : [Observable<any>, Subscription]
{
  let params: RequestParams = new RequestParams();

  params.add("diamond", diamond);

  let actionUrl = '/app/diamond/appraise/rawResponse';

  let observable: Observable<any> = axeHttp.createRequest(actionUrl, params);
  let subscription: Subscription = null;

  subscription = observable.subscribe();


  return [observable, subscription];
}

export type AppraiseDiamondTextSuccessHandler =
  (response: string) => void;

export function appraiseDiamondText(diamond: Diamond,
                                    successHandler?: AppraiseDiamondTextSuccessHandler,
                                    errorHandler?: ErrorHandler) : [Observable<any>, Subscription]
{
  let params: RequestParams = new RequestParams();

  params.add("diamond", diamond);

  let actionUrl = '/app/diamond/appraise/text';

  let observable: Observable<any> = axeHttp.createRequest(actionUrl, params);
  let subscription: Subscription = null;

  if (successHandler)
  {
    if (!errorHandler)
    {
      errorHandler = axeHttp.defaultOnError;
    }

    subscription = observable.subscribe(successHandler,
                                        errorHandler);
  }

  return [observable, subscription];
}

export type BuyDiamondSuccessHandler =
  (response: Diamond) => void;

export function buyDiamond(weight: number,
                           minedOn: Day,
                           deadline: Date,
                           preferredName: string,
                           preferredCountries: Array<string>,
                           successHandler?: BuyDiamondSuccessHandler,
                           errorHandler?: ErrorHandler) : [Observable<any>, Subscription]
{
  let params: RequestParams = new RequestParams();

  params.add("weight", weight);
  params.add("minedOn", minedOn);
  params.add("deadline", deadline);
  params.add("preferredName", preferredName);
  params.add("preferredCountries", preferredCountries);

  let actionUrl = '/app/diamond/buy';

  let observable: Observable<any> = axeHttp.createRequest(actionUrl, params);
  let subscription: Subscription = null;

  if (successHandler)
  {
    if (!errorHandler)
    {
      errorHandler = axeHttp.defaultOnError;
    }

    subscription = observable.subscribe(successHandler,
                                        errorHandler);
  }

  return [observable, subscription];
}

export type FindBuyerDiamondSuccessHandler =
  (response: FindBuyerDiamondResponse) => void;

export interface FindBuyerDiamondResponse
{
  buyer: Buyer;
}

export function findBuyerDiamond(seller: Seller,
                                 successHandler?: FindBuyerDiamondSuccessHandler,
                                 errorHandler?: ErrorHandler) : [Observable<any>, Subscription]
{
  let params: RequestParams = new RequestParams();

  params.add("seller", seller);

  let actionUrl = '/app/diamond/findBuyer';

  let observable: Observable<any> = axeHttp.createRequest(actionUrl, params);
  let subscription: Subscription = null;

  if (successHandler)
  {
    if (!errorHandler)
    {
      errorHandler = axeHttp.defaultOnError;
    }

    subscription = observable.subscribe(successHandler,
                                        errorHandler);
  }

  return [observable, subscription];
}

export type FindPersonDiamondSuccessHandler =
  (response: FindPersonDiamondResponse) => void;

export interface FindPersonDiamondResponse
{
  person: Seller | Buyer;
}

export function findPersonDiamond(personName: string,
                                  successHandler?: FindPersonDiamondSuccessHandler,
                                  errorHandler?: ErrorHandler) : [Observable<any>, Subscription]
{
  let params: RequestParams = new RequestParams();

  params.add("personName", personName);

  let actionUrl = '/app/diamond/findPerson';

  let observable: Observable<any> = axeHttp.createRequest(actionUrl, params);
  let subscription: Subscription = null;

  if (successHandler)
  {
    if (!errorHandler)
    {
      errorHandler = axeHttp.defaultOnError;
    }

    subscription = observable.subscribe(successHandler,
                                        errorHandler);
  }

  return [observable, subscription];
}

export type FindPersonDiamondExistsSuccessHandler =
  (response: FindPersonDiamondExistsResponse) => void;

export interface FindPersonDiamondExistsResponse
{
  exists: boolean;
}

export function findPersonDiamondExists(person: Seller | Buyer,
                                        successHandler?: FindPersonDiamondExistsSuccessHandler,
                                        errorHandler?: ErrorHandler) : [Observable<any>, Subscription]
{
  let params: RequestParams = new RequestParams();

  params.add("person", person);

  let actionUrl = '/app/diamond/findPerson/exists';

  let observable: Observable<any> = axeHttp.createRequest(actionUrl, params);
  let subscription: Subscription = null;

  if (successHandler)
  {
    if (!errorHandler)
    {
      errorHandler = axeHttp.defaultOnError;
    }

    subscription = observable.subscribe(successHandler,
                                        errorHandler);
  }

  return [observable, subscription];
}

export type ListDiamondSuccessHandler =
  (response: ListDiamondResponse) => void;

export interface ListDiamondResponse
{
  names: Array<string>;
}

export function listDiamond(successHandler?: ListDiamondSuccessHandler,
                            errorHandler?: ErrorHandler) : [Observable<any>, Subscription]
{
  let params: RequestParams = new RequestParams();

  let actionUrl = '/app/diamond/list';

  let observable: Observable<any> = axeHttp.createRequest(actionUrl, params);
  let subscription: Subscription = null;

  if (successHandler)
  {
    if (!errorHandler)
    {
      errorHandler = axeHttp.defaultOnError;
    }

    subscription = observable.subscribe(successHandler,
                                        errorHandler);
  }

  return [observable, subscription];
}

export type SellDiamondSuccessHandler =
  (response: SellDiamondResponse) => void;

export interface SellDiamondResponse
{
  change: number;
  sellerName: string;
}

export function sellDiamond(diamond: Diamond,
                            successHandler?: SellDiamondSuccessHandler,
                            errorHandler?: ErrorHandler) : [Observable<any>, Subscription]
{
  let params: RequestParams = new RequestParams();

  params.add("diamond", diamond);

  let actionUrl = '/app/diamond/sell';

  let observable: Observable<any> = axeHttp.createRequest(actionUrl, params);
  let subscription: Subscription = null;

  if (successHandler)
  {
    if (!errorHandler)
    {
      errorHandler = axeHttp.defaultOnError;
    }

    subscription = observable.subscribe(successHandler,
                                        errorHandler);
  }

  return [observable, subscription];
}

export type UploadDiamondSuccessHandler =
  (response: UploadDiamondResponse) => void;

export interface UploadDiamondResponse
{
  numFilesReceived: number;
}

export function uploadDiamond(numDiamonds: number,
                              singleFile: File,
                              multiFiles: FileList,
                              successHandler?: UploadDiamondSuccessHandler,
                              errorHandler?: ErrorHandler) : [Observable<any>, Subscription]
{
  let params: RequestParams = new RequestParams();

  params.add("numDiamonds", numDiamonds);

  let formData = new FormData();

  formData.append("singleFile", singleFile);
  axeHttp.appendFileList(formData, "multiFiles", multiFiles);

  let actionUrl = '/app/diamond/upload';

  let observable: Observable<any> = axeHttp.createRequest(actionUrl, params, "POST", formData);
  let subscription: Subscription = null;

  if (successHandler)
  {
    if (!errorHandler)
    {
      errorHandler = axeHttp.defaultOnError;
    }

    subscription = observable.subscribe(successHandler,
                                        errorHandler);
  }

  return [observable, subscription];
}




// The types below are private implementation classes.
// Do not use them.
// You should instead use the interfaces listed above.

class BasicAppraiseDiamondResponse
{
  constructor(public value: number,
              public quality: string)
  {
  }

  static fromJson(src: AppraiseDiamondResponse) : BasicAppraiseDiamondResponse
  {
    return new BasicAppraiseDiamondResponse(src.value,
                                            src.quality);
  }

  static toJson(src: BasicAppraiseDiamondResponse) : AppraiseDiamondResponse
  {
    return src;
  }
}
class BasicAppraiseDiamondMultipleResponse
{
  constructor(public values: Array<number>)
  {
  }

  static fromJson(src: AppraiseDiamondMultipleResponse) : BasicAppraiseDiamondMultipleResponse
  {
    return new BasicAppraiseDiamondMultipleResponse(src.values);
  }

  static toJson(src: BasicAppraiseDiamondMultipleResponse) : AppraiseDiamondMultipleResponse
  {
    return src;
  }
}
class BasicFindBuyerDiamondResponse
{
  constructor(public buyer: Buyer)
  {
  }

  static fromJson(src: FindBuyerDiamondResponse) : BasicFindBuyerDiamondResponse
  {
    return new BasicFindBuyerDiamondResponse(src.buyer);
  }

  static toJson(src: BasicFindBuyerDiamondResponse) : FindBuyerDiamondResponse
  {
    return src;
  }
}
class BasicFindPersonDiamondResponse
{
  constructor(public person: Seller | Buyer)
  {
  }

  static fromJson(src: FindPersonDiamondResponse) : BasicFindPersonDiamondResponse
  {
    return new BasicFindPersonDiamondResponse(src.person);
  }

  static toJson(src: BasicFindPersonDiamondResponse) : FindPersonDiamondResponse
  {
    return src;
  }
}
class BasicFindPersonDiamondExistsResponse
{
  constructor(public exists: boolean)
  {
  }

  static fromJson(src: FindPersonDiamondExistsResponse) : BasicFindPersonDiamondExistsResponse
  {
    return new BasicFindPersonDiamondExistsResponse(src.exists);
  }

  static toJson(src: BasicFindPersonDiamondExistsResponse) : FindPersonDiamondExistsResponse
  {
    return src;
  }
}
class BasicListDiamondResponse
{
  constructor(public names: Array<string>)
  {
  }

  static fromJson(src: ListDiamondResponse) : BasicListDiamondResponse
  {
    return new BasicListDiamondResponse(src.names);
  }

  static toJson(src: BasicListDiamondResponse) : ListDiamondResponse
  {
    return src;
  }
}
class BasicSellDiamondResponse
{
  constructor(public change: number,
              public sellerName: string)
  {
  }

  static fromJson(src: SellDiamondResponse) : BasicSellDiamondResponse
  {
    return new BasicSellDiamondResponse(src.change,
                                        src.sellerName);
  }

  static toJson(src: BasicSellDiamondResponse) : SellDiamondResponse
  {
    return src;
  }
}
class BasicUploadDiamondResponse
{
  constructor(public numFilesReceived: number)
  {
  }

  static fromJson(src: UploadDiamondResponse) : BasicUploadDiamondResponse
  {
    return new BasicUploadDiamondResponse(src.numFilesReceived);
  }

  static toJson(src: BasicUploadDiamondResponse) : UploadDiamondResponse
  {
    return src;
  }
}



export function registerDefaults() : void
{
  ClassJsonRegistry.registry.register('AppraiseDiamondResponse',
                                      BasicAppraiseDiamondResponse,
                                      false);
  ClassJsonRegistry.registry.register('AppraiseDiamondMultipleResponse',
                                      BasicAppraiseDiamondMultipleResponse,
                                      false);
  ClassJsonRegistry.registry.register('FindBuyerDiamondResponse',
                                      BasicFindBuyerDiamondResponse,
                                      false);
  ClassJsonRegistry.registry.register('FindPersonDiamondResponse',
                                      BasicFindPersonDiamondResponse,
                                      false);
  ClassJsonRegistry.registry.register('FindPersonDiamondExistsResponse',
                                      BasicFindPersonDiamondExistsResponse,
                                      false);
  ClassJsonRegistry.registry.register('ListDiamondResponse',
                                      BasicListDiamondResponse,
                                      false);
  ClassJsonRegistry.registry.register('SellDiamondResponse',
                                      BasicSellDiamondResponse,
                                      false);
  ClassJsonRegistry.registry.register('UploadDiamondResponse',
                                      BasicUploadDiamondResponse,
                                      false);
}

export function registerDescs() : void
{
  let desc: ClassJsonDesc = null;

  desc = new ClassJsonDesc("AppraiseDiamondResponse");
  desc.addField("value", new JsonPrimitiveType("int"));
  desc.addField("quality", new JsonPrimitiveType("string"));
  ClassJsonRegistry.registry.addDesc(desc);

  desc = new ClassJsonDesc("AppraiseDiamondMultipleResponse");
  desc.addField("values", new JsonList(new JsonPrimitiveType("int")));
  ClassJsonRegistry.registry.addDesc(desc);

  desc = new ClassJsonDesc("Diamond");
  desc.addField("name", new JsonPrimitiveType("string"));
  desc.addField("weight", new JsonPrimitiveType("float"));
  desc.addField("numFaces", new JsonPrimitiveType("int"));
  ClassJsonRegistry.registry.addDesc(desc);

  desc = new ClassJsonDesc("FindBuyerDiamondResponse");
  desc.addField("buyer", new JsonObj("Buyer"));
  ClassJsonRegistry.registry.addDesc(desc);

  desc = new ClassJsonDesc("FindPersonDiamondResponse");
  desc.addField("person", new JsonObj("Person"));
  ClassJsonRegistry.registry.addDesc(desc);

  desc = new ClassJsonDesc("FindPersonDiamondExistsResponse");
  desc.addField("exists", new JsonPrimitiveType("bool"));
  ClassJsonRegistry.registry.addDesc(desc);

  desc = new ClassJsonDesc("ListDiamondResponse");
  desc.addField("names", new JsonList(new JsonPrimitiveType("string")));
  ClassJsonRegistry.registry.addDesc(desc);

  desc = new ClassJsonDesc("SellDiamondResponse");
  desc.addField("change", new JsonPrimitiveType("int"));
  desc.addField("sellerName", new JsonPrimitiveType("string"));
  ClassJsonRegistry.registry.addDesc(desc);

  desc = new ClassJsonDesc("UploadDiamondResponse");
  desc.addField("numFilesReceived", new JsonPrimitiveType("int"));
  ClassJsonRegistry.registry.addDesc(desc);
}
'''
