#-------------------------------------------------------------------
#  TestWebDescAppDocWriter.py
#
#  The TestWebDescAppDocWriter module.
#
#  Copyright 2016 Applied Invention, LLC
#-------------------------------------------------------------------

'''Unit test for the WebDescAppDocWriter class.
'''

#-------------------------------------------------------------------
# Import statements go here.
#
from ai.axe.web.api.desc import WebDesc
from ai.axe.web.api.desc import WebDescAppDocWriter
from ai.axe.build.unittest import AxeSimpleTestCase
#
# Import statements go above this line.
#-------------------------------------------------------------------

#===================================================================
class TestWebDescAppDocWriter(AxeSimpleTestCase):
  '''Unit test for the WebDescAppDocWriter class.
'''

  #-----------------------------------------------------------------
  def setUp(self) -> None:

    # Put initialization code here.  It will be run before each test.

    # pylint: disable=unused-import

    # Import the test web action.
    #
    # Import here within the test function so the test action
    # doesn't get created during normal application use.
    #
    # pylint: disable=import-outside-toplevel
    import ai.axe.web.api.desc.test.diamond

  #-----------------------------------------------------------------
  def tearDown(self) -> None:

    # Put finalization code here.  It will be run after each test.
    pass

  #-----------------------------------------------------------------
  def testDoc(self) -> None:
    '''Test generating a doc for web verbs.
    '''

    # Filter out only the 'diamond' noun.
    diamondVerbs = {"diamond": WebDesc.allVerbs(False)['diamond']}

    expected = TestWebDescAppDocWriter.diamondDescText
    actual = WebDescAppDocWriter.formatVerbDict(diamondVerbs)

    self.assertEqual(expected, actual, "Doc text")

  #-----------------------------------------------------------------
  def testCreation(self) -> None:
    '''Tests creating an object.
    '''

    # Doesn't test the returned values.
    # Just tests that no exception gets thrown, and gets test coverage up.

    str(WebDescAppDocWriter())

  #-----------------------------------------------------------------
  # The expected doc text for the 'diamond' web verb.
  diamondDescText = '''Web Action Functions

diamond

  appraise

  Web action for testing:  Appraise a diamond.

    Params:
      diamond  Diamond  The diamond to appraise.
    Param clases:
      {
        "_class" : "Diamond",
        "name" : <string>,
        "weight" : <float>,
        "numFaces" : <int>
      }
    Response:
      {
        "value" : <int>,
        "quality" : <string>
      }

    Typescript

      Call this web action like so:
      
        import { appraiseDiamond } from '../gen/webActions';
        import { AppraiseDiamondResponse } from '../gen/webActions';
      
        appraiseDiamond(diamond: Diamond,
                        successHandler?,
                        errorHandler?)
      
      where successHandler is a function you write like:
      
        handleSuccess(response: AppraiseDiamondResponse) : void
        {
        }
      
      and the 'response' object has the following fields:
      
        value: number
        quality: string

  appraise/image

  Web action for testing:  Appraise a diamond and download an image.

    Params:
      diamond  Diamond  The diamond to appraise.
    Param clases:
      {
        "_class" : "Diamond",
        "name" : <string>,
        "weight" : <float>,
        "numFaces" : <int>
      }
    Response:
      BinaryResponse

    Typescript

      Call this web action like so:
      
        import { appraiseDiamondImage } from '../gen/webActions';
      
        appraiseDiamondImage(diamond: Diamond)

  appraise/multiple

  Web action for testing:  Appraise multiple diamonds.

    Params:
      diamonds  list:Diamond  The diamonds to appraise.
    Param clases:
      {
        "_class" : "Diamond",
        "name" : <string>,
        "weight" : <float>,
        "numFaces" : <int>
      }
    Response:
      {
        "values" : <[int]>
      }

    Typescript

      Call this web action like so:
      
        import { appraiseDiamondMultiple } from '../gen/webActions';
        import { AppraiseDiamondMultipleResponse } from '../gen/webActions';
      
        appraiseDiamondMultiple(diamonds: Array<Diamond>,
                                successHandler?,
                                errorHandler?)
      
      where successHandler is a function you write like:
      
        handleSuccess(response: AppraiseDiamondMultipleResponse) : void
        {
        }
      
      and the 'response' object has the following fields:
      
        values: Array<number>

  appraise/noResponse

  Web action for testing:  Appraise a diamond and get no response.

    Params:
      diamond  Diamond  The diamond to appraise.
    Param clases:
      {
        "_class" : "Diamond",
        "name" : <string>,
        "weight" : <float>,
        "numFaces" : <int>
      }
    Response:
      Response has no data

    Typescript

      Call this web action like so:
      
        import { appraiseDiamondNoResponse } from '../gen/webActions';
      
        appraiseDiamondNoResponse(diamond: Diamond,
                                  successHandler?,
                                  errorHandler?)
      
      where successHandler is a function you write like:
      
        handleSuccess() : void
        {
        }

  appraise/pdf

  Web action for testing:  Appraise a diamond and download a PDF.

    Params:
      diamond  Diamond  The diamond to appraise.
    Param clases:
      {
        "_class" : "Diamond",
        "name" : <string>,
        "weight" : <float>,
        "numFaces" : <int>
      }
    Response:
      DownloadResponse

    Typescript

      Call this web action like so:
      
        import { appraiseDiamondPdf } from '../gen/webActions';
      
        appraiseDiamondPdf(diamond: Diamond)

  appraise/rawResponse

  Web action for testing:  Appraise a diamond and download a raw response.

    Params:
      diamond  Diamond  The diamond to appraise.
    Param clases:
      {
        "_class" : "Diamond",
        "name" : <string>,
        "weight" : <float>,
        "numFaces" : <int>
      }
    Response:
      Raw HTTP response

    Typescript

      Call this web action like so:
      
        import { appraiseDiamondRawResponse } from '../gen/webActions';
      
        appraiseDiamondRawResponse(diamond: Diamond)

  appraise/text

  Web action for testing:  Appraise a diamond and download some text.

    Params:
      diamond  Diamond  The diamond to appraise.
    Param clases:
      {
        "_class" : "Diamond",
        "name" : <string>,
        "weight" : <float>,
        "numFaces" : <int>
      }
    Response:
      Plain text

    Typescript

      Call this web action like so:
      
        import { appraiseDiamondText } from '../gen/webActions';
      
        appraiseDiamondText(diamond: Diamond,
                            successHandler?,
                            errorHandler?)
      
      where successHandler is a function you write like:
      
        handleSuccess(response: string) : void
        {
        }

  buy

  Web action for testing:  Buy a diamond.

    Params:
      weight  float  The desired weight.
      minedOn  date  The desired date the diamond was mined.
      deadline  datetime  The sale must be made by this time.
      preferredName  string  The desired name.
      preferredCountries  string_list  A list of acceptable countries.
    Param clases:
    Response:
      {
        "_class" : "Diamond",
        "name" : <string>,
        "weight" : <float>,
        "numFaces" : <int>
      }

    Typescript

      Call this web action like so:
      
        import { buyDiamond } from '../gen/webActions';
        import { Diamond } from '../gen/classJsonInterface';
      
        buyDiamond(weight: number,
                   minedOn: Day,
                   deadline: Date,
                   preferredName: string,
                   preferredCountries: Array<string>,
                   successHandler?,
                   errorHandler?)
      
      where successHandler is a function you write like:
      
        handleSuccess(response: Diamond) : void
        {
        }
      
      and the 'response' object has the following fields:
      
        name: string
        weight: number
        numFaces: number

  findBuyer

  Web action for testing:  Find a buyer.

    Params:
      seller  Seller  The seller to find a buyer for.
    Param clases:
      {
        "_class" : "Seller",
        "name" : <string>,
        "minPriceAccepted" : <int>
      }
    Response:
      {
        "buyer" : <Buyer>
      }
        {
          "_class" : "Buyer",
          "name" : <string>,
          "maxBid" : <int>
        }

    Typescript

      Call this web action like so:
      
        import { findBuyerDiamond } from '../gen/webActions';
        import { FindBuyerDiamondResponse } from '../gen/webActions';
      
        findBuyerDiamond(seller: Seller,
                         successHandler?,
                         errorHandler?)
      
      where successHandler is a function you write like:
      
        handleSuccess(response: FindBuyerDiamondResponse) : void
        {
        }
      
      and the 'response' object has the following fields:
      
        buyer: Buyer

  findPerson

  Web action for testing:  Find a person

    Params:
      personName  string  The name of the person to find.
    Param clases:
    Response:
      {
        "person" : <Person>
      }
        {
          "_class" : "Person",
          "name" : <string>
        }

    Typescript

      Call this web action like so:
      
        import { findPersonDiamond } from '../gen/webActions';
        import { FindPersonDiamondResponse } from '../gen/webActions';
      
        findPersonDiamond(personName: string,
                          successHandler?,
                          errorHandler?)
      
      where successHandler is a function you write like:
      
        handleSuccess(response: FindPersonDiamondResponse) : void
        {
        }
      
      and the 'response' object has the following fields:
      
        person: Seller | Buyer

  findPerson/exists

  Web action for testing:  Find a person

    Params:
      person  Person  The name of the person to find.
    Param clases:
      {
        "_class" : "Person",
        "name" : <string>
      }
    Response:
      {
        "exists" : <bool>
      }

    Typescript

      Call this web action like so:
      
        import { findPersonDiamondExists } from '../gen/webActions';
        import { FindPersonDiamondExistsResponse } from '../gen/webActions';
      
        findPersonDiamondExists(person: Seller | Buyer,
                                successHandler?,
                                errorHandler?)
      
      where successHandler is a function you write like:
      
        handleSuccess(response: FindPersonDiamondExistsResponse) : void
        {
        }
      
      and the 'response' object has the following fields:
      
        exists: boolean

  list

  Web action for testing:  List known diamonds.

    Params:
    Param clases:
    Response:
      {
        "names" : <[string]>
      }

    Typescript

      Call this web action like so:
      
        import { listDiamond } from '../gen/webActions';
        import { ListDiamondResponse } from '../gen/webActions';
      
        listDiamond(successHandler?,
                    errorHandler?)
      
      where successHandler is a function you write like:
      
        handleSuccess(response: ListDiamondResponse) : void
        {
        }
      
      and the 'response' object has the following fields:
      
        names: Array<string>

  sell

  Web action for testing:  Sell a diamond.

    Params:
      diamond  Diamond  The diamond to sell.
    Param clases:
      {
        "_class" : "Diamond",
        "name" : <string>,
        "weight" : <float>,
        "numFaces" : <int>
      }
    Response:
      {
        "change" : <int>,
        "sellerName" : <string>
      }

    Typescript

      Call this web action like so:
      
        import { sellDiamond } from '../gen/webActions';
        import { SellDiamondResponse } from '../gen/webActions';
      
        sellDiamond(diamond: Diamond,
                    successHandler?,
                    errorHandler?)
      
      where successHandler is a function you write like:
      
        handleSuccess(response: SellDiamondResponse) : void
        {
        }
      
      and the 'response' object has the following fields:
      
        change: number
        sellerName: string

  upload

  Web action for testing:  Upload a diamond.

    Params:
      numDiamonds  int  The number of diamonds involved.
      singleFile  file  A file to upload.
      multiFiles  file_list  Additional files to upload.
    Param clases:
    Response:
      {
        "numFilesReceived" : <int>
      }

    Typescript

      Call this web action like so:
      
        import { uploadDiamond } from '../gen/webActions';
        import { UploadDiamondResponse } from '../gen/webActions';
      
        uploadDiamond(numDiamonds: number,
                      singleFile: File,
                      multiFiles: FileList,
                      successHandler?,
                      errorHandler?)
      
      where successHandler is a function you write like:
      
        handleSuccess(response: UploadDiamondResponse) : void
        {
        }
      
      and the 'response' object has the following fields:
      
        numFilesReceived: number


'''
