#-------------------------------------------------------------------
#  TestDocParser.py
#
#  The TestDocParser module.
#
#  Copyright 2016 Applied Invention, LLC
#-------------------------------------------------------------------

'''Unit test for the DocParser class.
'''

#-------------------------------------------------------------------
# Import statements go here.
#
from ai.axe.web.api.desc import DocParser
from ai.axe.build.unittest import AxeSimpleTestCase
#
# Import statements go above this line.
#-------------------------------------------------------------------

#===================================================================
class TestDocParser(AxeSimpleTestCase):
  '''Unit test for the DocParser class.
'''

  #-----------------------------------------------------------------
  def setUp(self) -> None:

    # Put initialization code here.  It will be run before each test.
    pass

  #-----------------------------------------------------------------
  def tearDown(self) -> None:

    # Put finalization code here.  It will be run after each test.
    pass

  #-----------------------------------------------------------------
  def testWhitespace(self) -> None:
    '''Test whitespace removal.
    '''

    text = '''Hello.
      Line 1.
      Line 2.
    Line 3.
      Line 4.
    '''

    expected = '''Hello.
  Line 1.
  Line 2.
Line 3.
  Line 4.'''

    actual = DocParser().trimWhite(text)

    self.assertEqual(expected, actual, msg='Trim white')

  #-----------------------------------------------------------------
  def testParsing(self) -> None:
    '''Test parsing a comment.
    '''

    text = '''This is a short description.

    This is paragraph one on a single line.

    This is paragraph
    two
    spanning multiple lines.

    This is paragraph
    three
    spanning multiple lines.
    @param foo Single line foo description.
    @param bar Multi 
               line bar
               description.

    @param baz Single line baz description.
    @return The return type.
    '''

    comment = DocParser().parse(text)

    expected = 'This is a short description.'
    self.assertEqual(expected, comment.shortDesc, msg='shortDesc')

    expected2 = [
      'This is paragraph one on a single line.',
      'This is paragraph two spanning multiple lines.',
      'This is paragraph three spanning multiple lines.',
      ]
    self.assertEqual(expected2, comment.longDesc, msg='longDesc')

    self.assertEqual(3, len(comment.params), msg="# params")

    expected = 'Single line foo description.'
    self.assertEqual(expected, comment.params['foo'], msg='foo param')

    expected = 'Single line foo description.'
    self.assertEqual(expected, comment.params['foo'], msg='foo param')

    expected = 'Multi line bar description.'
    self.assertEqual(expected, comment.params['bar'], msg='bar param')

    expected = 'Single line baz description.'
    self.assertEqual(expected, comment.params['baz'], msg='baz param')

    expected = 'The return type.'
    self.assertEqual(expected, comment.returnDesc, msg='return desc')
