#-------------------------------------------------------------------
#  DocComment.py
#
#  The DocComment class.
#
#  Copyright 2016 Applied Invention, LLC
#-------------------------------------------------------------------

'''The module containing the DocComment class.
'''

#-------------------------------------------------------------------
# Import statements go here.
#
from ai.axe.util import StringUtil
from typing import Dict
from typing import List
#
# Import statements go above this line.
#-------------------------------------------------------------------


#===================================================================
class DocComment:
  '''A doc comment for a function.
  '''

  #-----------------------------------------------------------------
  def __init__(self,
               shortDesc: str,
               longDesc: List[str],
               params: Dict[str, str],
               returnDesc: str) -> None:
    '''Creates a new DocComment.
    '''

    # The short description (the first line of text).
    self.shortDesc: str = shortDesc

    # A list of paragraphs that make up the long description.
    self.longDesc: List[str] = longDesc

    # The @webParam doc strings for each parameter.
    self.params: Dict[str, str] = params

    # The return type description.
    self.returnDesc = returnDesc

  #----------------------------------------------------------------
  def __repr__(self) -> str:
    '''Returns a string representation of this object
    '''
    attrs: List[str] = ['shortDesc',
                        'longDesc',
                        'params',
                        'returnDesc']

    return StringUtil.formatRepr(self, attrs)
