#-------------------------------------------------------------------
#  WebWorkerContext.py
#
#  The WebWorkerContext class.
#
#  Copyright 2018 Applied Invention, LLC
#-------------------------------------------------------------------

'''The module containing the WebWorkerContext class.
'''

#-------------------------------------------------------------------
# Import statements go here.
#
from ai.axe.db.DatabaseMgr import DatabaseMgr
#
# Import statements go above this line.
#-------------------------------------------------------------------


#===================================================================
class WebWorkerContext:
  '''The context in which a WebWorkerRunner is running.
  '''

  #-----------------------------------------------------------------
  def __init__(self) -> None:
    '''Creates a new WebWorkerContext.
    '''

    pass

  #-----------------------------------------------------------------
  def setWebWorkerName(self, webWorkerName: str) -> None:
    '''Sets the web worker name to be included in any log messages.
    '''

    raise NotImplementedError()

  #-----------------------------------------------------------------
  def getDatabaseMgr(self) -> DatabaseMgr:
    '''Returns the database under which this is running.
    '''

    raise NotImplementedError()

  #-----------------------------------------------------------------
  def doPostSuccess(self) -> None:
    '''Called after a successful action.
    '''

    raise NotImplementedError()

  #-----------------------------------------------------------------
  def doPostFailure(self, exceptionStr: str) -> None:
    '''Called after a failed action.

    @param ex The exception that caused the failure.
    '''

    raise NotImplementedError()
