#-------------------------------------------------------------------
#  BinaryResponse.py
#
#  The BinaryResponse class.
#
#  Copyright 2016 Applied Invention, LLC
#-------------------------------------------------------------------

'''The module containing the BinaryResponse class.
'''

#-------------------------------------------------------------------
# Import statements go here.
#
from typing import Union
from werkzeug.wrappers import Response
#
# Import statements go above this line.
#-------------------------------------------------------------------


#===================================================================
class BinaryResponse:
  '''An HTTP response that is binary data.
  '''

  #-----------------------------------------------------------------
  def __init__(self, data: Union[str, bytes], mimeType: str) -> None:
    '''Creates a new BinaryResponse.
    '''

    # The data to be downloaded.
    self.data: Union[str, bytes] = data

    # The mime type of the data.
    self.mimeType: str = mimeType

  #-----------------------------------------------------------------
  def createHttpResponse(self) -> Response:
    '''Writes the download to an HTTP response.
    '''

    response = Response(self.data, mimetype=self.mimeType)

    return response
